#include "driver.h"
#include "common.h"

INLINE UINT8 NIBBLE(UINT32 n, UINT8 a, UINT8 b, UINT8 c, UINT8 d)
{
	UINT32 a1 = (n >> a) & 0x1;
	UINT32 b1 = (n >> b) & 0x1;
	UINT32 c1 = (n >> c) & 0x1;
	UINT32 d1 = (n >> d) & 0x1;
	return ((a1 << 3) | (b1 << 2) | (c1 << 1) | d1);
}

static unsigned char crypt_table1[][16] =
{
	/*  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   A,   B,   C,   D,   E,   F */
	{ 0xa, 0xe, 0x2, 0x6, 0xb, 0xf, 0x3, 0x7, 0x8, 0xc, 0x0, 0x4, 0x9, 0xd, 0x1, 0x5 },
	{ 0x8, 0xc, 0x0, 0x4, 0x9, 0xd, 0x1, 0x5, 0xb, 0xf, 0x3, 0x7, 0x2, 0x6, 0xe, 0xa },
};

static unsigned char crypt_table2[][16] =
{
	/*  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   A,   B,   C,   D,   E,   F */
	{ 0x2, 0x6, 0x3, 0x7, 0x1, 0x5, 0x0, 0x4, 0x9, 0xe, 0x8, 0xf, 0xb, 0xd, 0xa, 0xc },
	{ 0x9, 0xe, 0x8, 0xf, 0xb, 0xd, 0xa, 0xc, 0x2, 0x6, 0x3, 0x7, 0x1, 0x5, 0x0, 0x4 },

	{ 0x6, 0x2, 0x7, 0x3, 0x5, 0x1, 0x4, 0x0, 0xe, 0x9, 0xf, 0x8, 0xd, 0xb, 0xc, 0xa },
	{ 0xe, 0x9, 0xf, 0x8, 0xd, 0xb, 0xc, 0xa, 0x6, 0x2, 0x7, 0x3, 0x5, 0x1, 0x4, 0x0 },
};

static unsigned char crypt_table3[][16] =
{
	/*  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   A,   B,   C,   D,   E,   F */
	{ 0x9, 0xd, 0x1, 0x5, 0x8, 0xc, 0x0, 0x4, 0xb, 0xf, 0x3, 0x7, 0xa, 0xe, 0x2, 0x6 },
	{ 0x8, 0xc, 0x0, 0x4, 0x1, 0x5, 0x9, 0xd, 0xa, 0xe, 0x2, 0x6, 0x3, 0x7, 0xb, 0xf },
	{ 0x1, 0x5, 0x9, 0xd, 0x0, 0x4, 0x8, 0xc, 0x3, 0x7, 0xb, 0xf, 0x2, 0x6, 0xa, 0xe },
	{ 0x0, 0x4, 0x8, 0xc, 0x9, 0xd, 0x1, 0x5, 0x2, 0x6, 0xa, 0xe, 0xb, 0xf, 0x3, 0x7 },
	{ 0x9, 0xd, 0x5, 0x3, 0x8, 0xc, 0x4, 0x2, 0xb, 0xf, 0x7, 0x1, 0xa, 0xe, 0x6, 0x0 },
	{ 0x8, 0xc, 0x4, 0x2, 0x5, 0x3, 0x9, 0xd, 0xa, 0xe, 0x6, 0x0, 0x7, 0x1, 0xb, 0xf },
	{ 0x5, 0x3, 0x9, 0xd, 0x4, 0x2, 0x8, 0xc, 0x7, 0x1, 0xb, 0xf, 0x6, 0x0, 0xa, 0xe },
	{ 0x4, 0x2, 0x8, 0xc, 0x9, 0xd, 0x5, 0x3, 0x6, 0x0, 0xa, 0xe, 0xb, 0xf, 0x7, 0x1 },

	{ 0xd, 0xb, 0x5, 0x3, 0xc, 0xa, 0x4, 0x2, 0xf, 0x9, 0x7, 0x1, 0xe, 0x8, 0x6, 0x0 },
	{ 0xc, 0xa, 0x4, 0x2, 0x5, 0x3, 0xd, 0xb, 0xe, 0x8, 0x6, 0x0, 0x7, 0x1, 0xf, 0x9 },
	{ 0x5, 0x3, 0xd, 0xb, 0x4, 0x2, 0xc, 0xa, 0x7, 0x1, 0xf, 0x9, 0x6, 0x0, 0xe, 0x8 },
	{ 0x4, 0x2, 0xc, 0xa, 0xd, 0xb, 0x5, 0x3, 0x6, 0x0, 0xe, 0x8, 0xf, 0x9, 0x7, 0x1 },
	{ 0xd, 0xb, 0x3, 0x7, 0xc, 0xa, 0x2, 0x6, 0xf, 0x9, 0x1, 0x5, 0xe, 0x8, 0x0, 0x4 },
	{ 0xc, 0xa, 0x2, 0x6, 0x3, 0x7, 0xd, 0xb, 0xe, 0x8, 0x0, 0x4, 0x1, 0x5, 0xf, 0x9 },
	{ 0x3, 0x7, 0xd, 0xb, 0x2, 0x6, 0xc, 0xa, 0x1, 0x5, 0xf, 0x9, 0x0, 0x4, 0xe, 0x8 },
	{ 0x2, 0x6, 0xc, 0xa, 0xd, 0xb, 0x3, 0x7, 0x0, 0x4, 0xe, 0x8, 0xf, 0x9, 0x1, 0x5 },


	{ 0xb, 0xf, 0x3, 0x7, 0xa, 0xe, 0x2, 0x6, 0x9, 0xd, 0x1, 0x5, 0x8, 0xc, 0x0, 0x4 },
	{ 0xa, 0xe, 0x2, 0x6, 0x3, 0x7, 0xb, 0xf, 0x8, 0xc, 0x0, 0x4, 0x1, 0x5, 0x9, 0xd },
	{ 0x3, 0x7, 0xb, 0xf, 0x2, 0x6, 0xa, 0xe, 0x1, 0x5, 0x9, 0xd, 0x0, 0x4, 0x8, 0xc },
	{ 0x2, 0x6, 0xa, 0xe, 0xb, 0xf, 0x3, 0x7, 0x0, 0x4, 0x8, 0xc, 0x9, 0xd, 0x1, 0x5 },
	{ 0xb, 0xf, 0x7, 0x1, 0xa, 0xe, 0x6, 0x0, 0x9, 0xd, 0x5, 0x3, 0x8, 0xc, 0x4, 0x2 },
	{ 0xa, 0xe, 0x6, 0x0, 0x7, 0x1, 0xb, 0xf, 0x8, 0xc, 0x4, 0x2, 0x5, 0x3, 0x9, 0xd },
	{ 0x7, 0x1, 0xb, 0xf, 0x6, 0x0, 0xa, 0xe, 0x5, 0x3, 0x9, 0xd, 0x4, 0x2, 0x8, 0xc },
	{ 0x6, 0x0, 0xa, 0xe, 0xb, 0xf, 0x7, 0x1, 0x4, 0x2, 0x8, 0xc, 0x9, 0xd, 0x5, 0x3 },

	{ 0xf, 0x9, 0x7, 0x1, 0xe, 0x8, 0x6, 0x0, 0xd, 0xb, 0x5, 0x3, 0xc, 0xa, 0x4, 0x2 },
	{ 0xe, 0x8, 0x6, 0x0, 0x7, 0x1, 0xf, 0x9, 0xc, 0xa, 0x4, 0x2, 0x5, 0x3, 0xd, 0xb },
	{ 0x7, 0x1, 0xf, 0x9, 0x6, 0x0, 0xe, 0x8, 0x5, 0x3, 0xd, 0xb, 0x4, 0x2, 0xc, 0xa },
	{ 0x6, 0x0, 0xe, 0x8, 0xf, 0x9, 0x7, 0x1, 0x4, 0x2, 0xc, 0xa, 0xd, 0xb, 0x5, 0x3 },
	{ 0xf, 0x9, 0x1, 0x5, 0xe, 0x8, 0x0, 0x4, 0xd, 0xb, 0x3, 0x7, 0xc, 0xa, 0x2, 0x6 },
	{ 0xe, 0x8, 0x0, 0x4, 0x1, 0x5, 0xf, 0x9, 0xc, 0xa, 0x2, 0x6, 0x3, 0x7, 0xd, 0xb },
	{ 0x1, 0x5, 0xf, 0x9, 0x0, 0x4, 0xe, 0x8, 0x3, 0x7, 0xd, 0xb, 0x2, 0x6, 0xc, 0xa },
	{ 0x0, 0x4, 0xe, 0x8, 0xf, 0x9, 0x1, 0x5, 0x2, 0x6, 0xc, 0xa, 0xd, 0xb, 0x3, 0x7 },
};

static unsigned char crypt_table4[][16] =
{
	/*  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   A,   B,   C,   D,   E,   F */
	{ 0xc, 0x8, 0xF, 0x2, 0xf, 0x8, 0xF, 0xF, 0x1, 0x5, 0x9, 0xd, 0x7, 0xe, 0xb, 0xF },
};

static unsigned char crypt_table5[][16] =
{
	/*  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   A,   B,   C,   D,   E,   F */
	{ 0x7, 0x7, 0xb, 0xb, 0x3, 0x3, 0xf, 0xf, 0x7, 0x7, 0xb, 0xb, 0x3, 0x3, 0xf, 0xf },
	{ 0x7, 0x7, 0xf, 0xf, 0x3, 0x3, 0xb, 0xb, 0x7, 0x7, 0xf, 0xf, 0x3, 0x3, 0xb, 0xb },
};

static unsigned char crypt_table6[16][16] = 
{
	/*  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   A,   B,   C,   D,   E,   F */
	{ 0x5, 0x4, 0x6, 0x7, 0x9, 0x8, 0xa, 0xb, 0x1, 0x0, 0x2, 0x3, 0xd, 0xc, 0xe, 0xf },
	{ 0x9, 0x8, 0xa, 0xb, 0x1, 0x0, 0x2, 0x3, 0xd, 0xc, 0xe, 0xf, 0x5, 0x4, 0x6, 0x7 },
	{ 0x1, 0x0, 0x2, 0x3, 0xd, 0xc, 0xe, 0xf, 0x5, 0x4, 0x6, 0x7, 0x9, 0x8, 0xa, 0xb },
	{ 0xd, 0xc, 0xe, 0xf, 0x5, 0x4, 0x6, 0x7, 0x9, 0x8, 0xa, 0xb, 0x1, 0x0, 0x2, 0x3 },
	{ 0x6, 0x7, 0x4, 0x5, 0xa, 0xb, 0x8, 0x9, 0x2, 0x3, 0x0, 0x1, 0xe, 0xf, 0xc, 0xd },
	{ 0xa, 0xb, 0x8, 0x9, 0x2, 0x3, 0x0, 0x1, 0xe, 0xf, 0xc, 0xd, 0x6, 0x7, 0x4, 0x5 },
	{ 0x2, 0x3, 0x0, 0x1, 0xe, 0xf, 0xc, 0xd, 0x6, 0x7, 0x4, 0x5, 0xa, 0xb, 0x8, 0x9 },
	{ 0xe, 0xf, 0xc, 0xd, 0x6, 0x7, 0x4, 0x5, 0xa, 0xb, 0x8, 0x9, 0x2, 0x3, 0x0, 0x1 },

	{ 0x4, 0x5, 0x7, 0x6, 0x8, 0x9, 0xb, 0xa, 0x0, 0x1, 0x3, 0x2, 0xc, 0xd, 0xf, 0xe },
	{ 0x8, 0x9, 0xb, 0xa, 0x0, 0x1, 0x3, 0x2, 0xc, 0xd, 0xf, 0xe, 0x4, 0x5, 0x7, 0x6 },
	{ 0x0, 0x1, 0x3, 0x2, 0xc, 0xd, 0xf, 0xe, 0x4, 0x5, 0x7, 0x6, 0x8, 0x9, 0xb, 0xa },
	{ 0xc, 0xd, 0xf, 0xe, 0x4, 0x5, 0x7, 0x6, 0x8, 0x9, 0xb, 0xa, 0x0, 0x1, 0x3, 0x2 },
	{ 0x7, 0x6, 0x5, 0x4, 0xb, 0xa, 0x9, 0x8, 0x3, 0x2, 0x1, 0x0, 0xf, 0xe, 0xd, 0xc },
	{ 0xb, 0xa, 0x9, 0x8, 0x3, 0x2, 0x1, 0x0, 0xf, 0xe, 0xd, 0xc, 0x7, 0x6, 0x5, 0x4 },
	{ 0x3, 0x2, 0x1, 0x0, 0xf, 0xe, 0xd, 0xc, 0x7, 0x6, 0x5, 0x4, 0xb, 0xa, 0x9, 0x8 },
	{ 0xf, 0xe, 0xd, 0xc, 0x7, 0x6, 0x5, 0x4, 0xb, 0xa, 0x9, 0x8, 0x3, 0x2, 0x1, 0x0 }
};


static UINT8 dc1(UINT32 b, int adr)
{
	UINT8 db;
	UINT8 nb = NIBBLE(b, 22,21,20,16);
	int t;

	t = ((adr + 0x450) >> 15) & 0x1;

	db = crypt_table1[t][nb];
	return db;
}

static UINT8 dc2(UINT32 b, int adr)
{
	UINT8 db;
	UINT8 nb = NIBBLE(b, 23,19,18,6);
	int t;

	t = 0;
	t |= ((adr + 0x450) >> 12) & 0x1;
	t |= (((adr + 0x450) >> 15) & 0x1) << 1;

	db = crypt_table2[t][nb];
	return db;
}

static UINT8 dc3(UINT32 b, int adr)
{
	int t;
	UINT8 nb = NIBBLE(b, 14,13,8,4);
	UINT8 db;

	t = 0;
	t |= ((adr + 0x50) >> 7) & 0x3;
	t |= (((adr + 0x450) >> 12) & 0x3) << 2;
	t |= (((adr + 0x450) >> 14) & 0x1) << 4;

	db = crypt_table3[t][nb];
	return db;
}

static UINT8 dc4(UINT32 b, int adr)
{
	UINT8 db;
	UINT8 nb = 0;

	db = crypt_table4[0][nb];
	return 0xf;
}

static UINT8 dc5(UINT32 b, int adr)
{
	UINT8 db;
	UINT8 nb = 0;

	db = crypt_table5[0][nb];
	return 0xf;
}

static UINT8 dc6(UINT32 b, int adr)
{
	int t;
	UINT8 nb = NIBBLE(b, 3,2,1,0);
	UINT8 db;

	t = (adr >> 4) & 0x3;
	t |= (((adr + 0x50) >> 10) & 0x3) << 2;

	db = crypt_table6[t][nb];
	return db;
}

void seibuspi_text_decrypt(unsigned char *rom)
{
	int i;
	for(i=0; i<0x10000; i++) {
		UINT8 r1,r2,r3,r4,r5,r6;
		UINT32 w;

		w = (rom[(i*3) + 0] << 16) | (rom[(i*3) + 1] << 8) | (rom[(i*3) +2]);

		r1 = dc1(w, i);
		r2 = dc2(w, i);
		r3 = dc3(w, i);
		r4 = dc4(w, i);
		r5 = dc5(w, i);
		r6 = dc6(w, i);

		rom[(i*3) + 0] = (((r1 & 0x0c) | (r2 & 0x03)) << 4) | (r2 & 0x0c) | (r1 & 0x03);
		rom[(i*3) + 1] = (((r4 & 0x0c) | (r5 & 0x03)) << 4) | (r5 & 0x0c) | (r4 & 0x03);
		rom[(i*3) + 2] = (((r3 & 0x0c) | (r6 & 0x03)) << 4) | (r6 & 0x0c) | (r3 & 0x03);
   }
}

void seibuspi_bg_decrypt(unsigned char *rom, int size)
{
	int i,j;
	for(j=0; j<size; j+=0xc0000) {
		for(i=0; i<0x40000; i++) {
			UINT8 r1,r2,r3,r4,r5,r6;
			UINT32 w;

			w = (rom[j + (i*3) + 0] << 16) | (rom[j + (i*3) + 1] << 8) | (rom[j + (i*3) + 2]);

			r1 = dc1(w, i/4);
			r2 = dc2(w, i/4);
			r3 = dc3(w, i/4);
			r4 = dc4(w, i/4);
			r5 = dc5(w, i/4);
			r6 = dc6(w, i/4);

			rom[j + (i*3) + 0] = (((r1 & 0x0c) | (r2 & 0x03)) << 4) | (r2 & 0x0c) | (r1 & 0x03);
			rom[j + (i*3) + 1] = (((r4 & 0x0c) | (r5 & 0x03)) << 4) | (r5 & 0x0c) | (r4 & 0x03);
			rom[j + (i*3) + 2] = (((r3 & 0x0c) | (r6 & 0x03)) << 4) | (r6 & 0x0c) | (r3 & 0x03);
		}
	}
}

