#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

/* loadframe.c:
 *
 * manager for handling the load file dialog.  When a file is selected, do_load
 * in load.c is called.  This module uses the file picker that I wrote for
 * the graphics library, that resembles a Mac style file picker */

#include "interface.h"

#include "treedata.h"

static tload lf;
static tpcheck loadspecies;
static int loadingspecies;

int choose_species(c, e, v)
	/* if the "Load Species List" box is checked, we will interpret the file
	 * as if it were a species list instead of a tree file */
tpcheck c;
tevent e;
int v;
{
	loadingspecies=v;
}

int attempt_load(s, e)
	/* user selected to load a file, so attempt to load it */
char *s;
tevent e;
{
    int a;
    int do_load;
    char buf[80];

    do_load=0;

	if(s==NULL)
		return(1);

	seteventloc(e);

	/* either load a species list or a regular tree file */
	if(loadingspecies)
		return(do_command(Load, s, NULL, 0.0, 0.0,
			List, 0, 0, 0, 0));

	return(do_command(Load, s, NULL, 0.0, 0.0,
		Treetool, 0, 0, 0, 0));
}

create_load_dialog(p)
tframe p;
{
    char buf[1026];
	tpanel lp;
	titem below;

    getcwd(buf, 1024);
	/* create new file picker */
    lf=(tload)tload_new(p, 100, 100, globals->listfont, attempt_load,
		globals->args,
		"Load File", buf);
	tload_get_panel(lf, &lp, &below);
	/* add checkbox to bottom of file picker */
	loadspecies=tpcheck_new(lp, 10, 0, 0, 0, NULL, below,
		"Load Species List");
	tpcheck_set_event_procedure(loadspecies, choose_species);
	tpcheck_unset(loadspecies);
	loadingspecies=0;
	/* refit so room is made for the checkbox */
	tload_refit_panel(lf);
}
 
show_load_dialog()
{
	tload_move(lf, globals->ewin, globals->ex, globals->ey);
	tpcheck_unset(loadspecies);
	loadingspecies=0;
    tload_show(lf);
}

hide_load_dialog()
{
	tload_pull_pin(lf);
    tload_hide(lf);
}

load_busy()
{
    if(lf!=NULL)
        tload_set_busy(lf);
}

load_notbusy()
{
    if(lf!=NULL)
        tload_set_notbusy(lf);
}
