#include <stdio.h>

#include <xview/xview.h>
#include <xview/panel.h>
#include "generic.h"

typedef struct {
	ltgenericd g;
	Panel_item t;	/* xview panel item */
	int (*do_events)();
	} ltpsliderd, *ltpslider;

int tpslider_right_side(t)
ltpslider t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pslider)
		return(0);
	
	return(xv_get(t->t, XV_X)+xv_get(t->t, XV_WIDTH));
}

int tpslider_bottom_side(t)
ltpslider t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pslider)
		return(0);
	
	return(xv_get(t->t, XV_Y)+xv_get(t->t, XV_HEIGHT));
}

void tpslider_notify(item, v, e)
Panel_item item;
int v;
Event *e;
{
	ltpslider t;
	int a;
	int val;
	tevent te;

	t=(ltpslider)xv_get(item, PANEL_CLIENT_DATA);

	val=v;
	if(t->do_events!=NULL)
	{
		te=tevent_create_from_xviewevent(e, event_x(e), event_y(e), 0, 0);
		a=(*t->do_events)(t, te, val);
		tevent_free(te);
	}
	return;
}

tpslider tpslider_new(parent, x,y,w,h,right,below, name, min, max)
tpanel parent;
int x,y,w,h;
titem right,below;
char *name;
int min, max;
{
	ltpslider tmp;

	/* check types */
	if(parent==NULL)
		return(NULL);
	if(titem_type(parent)!=lt_panel)
		return(NULL);
	
	if(name==NULL)
		name="Slider Item";
	
	tmp=(ltpslider)titem_new(parent, lt_pslider, sizeof(ltpsliderd));
	if(tmp==NULL)
		return(NULL);
	
	tmp->t=(Panel_item)xv_create(tpanel_xview(parent), PANEL_SLIDER,
		PANEL_LABEL_STRING, name,
		PANEL_MIN_VALUE, min,
		PANEL_MAX_VALUE, max,
		XV_WIDTH, w,
		XV_HEIGHT, h,
		NULL);
	
	if(right!=NULL)
		x=tp_right_side(right);
	if(below!=NULL)
		y=tp_bottom_side(below);

	xv_set(tmp->t,
		XV_X, x,
		XV_Y, y,
		PANEL_CLIENT_DATA, tmp,
		PANEL_NOTIFY_LEVEL, PANEL_DONE,
		PANEL_NOTIFY_PROC, tpslider_notify,
		NULL);

	tmp->do_events=NULL;

	return(tmp);
}

int tpslider_free(t)
ltpslider t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pslider)
		return(0);
	
	xv_destroy_safe(t->t);
	return(titem_free(t));
}

int tpslider_get_val(t)
ltpslider t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pslider)
		return(0);
	
	return((int)xv_get(t->t, PANEL_VALUE));
}

int tpslider_set_val(t, s)
ltpslider t;
int s;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pslider)
		return(0);
	
	xv_set(t->t, PANEL_VALUE, s, NULL);
	return(1);
}

int tpslider_set_min(t, s)
ltpslider t;
int s;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pslider)
		return(0);
	
	xv_set(t->t, PANEL_MIN_VALUE, s, NULL);
	return(1);
}

int tpslider_set_max(t, s)
ltpslider t;
int s;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pslider)
		return(0);
	
	xv_set(t->t, PANEL_MAX_VALUE, s, NULL);
	return(1);
}

int tpslider_hide_range(t)
ltpslider t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pslider)
		return(0);
	
	xv_set(t->t, PANEL_SHOW_RANGE, FALSE, NULL);
	return(1);
}

int tpslider_enable(t)
ltpslider t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pslider)
		return(0);
	
	xv_set(t->t, PANEL_INACTIVE, FALSE, NULL);
	return(1);
}

int tpslider_disable(t)
ltpslider t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pslider)
		return(0);
	
	xv_set(t->t, PANEL_INACTIVE, TRUE, NULL);
	return(1);
}

int tpslider_set_event_procedure(t, do_events)
ltpslider t;
int (*do_events)();
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pslider)
		return(0);
	
	t->do_events=do_events;
	return(1);
}
