#charset "us-ascii"

/*
 *   Copyright (c) 1999, 2002 by Michael J. Roberts.  Permission is
 *   granted to anyone to copy and use this file for any purpose.  
 *   
 *   This is a starter TADS 3 source file.  This is a complete TADS game
 *   that you can compile and run.
 *   
 *   To compile this game in TADS Workbench, open the "Build" menu and
 *   select "Compile for Debugging."  To run the game, after compiling it,
 *   open the "Debug" menu and select "Go."
 *   
 *   This is the "advanced" starter game - it has only the minimum set of
 *   definitions needed for a working game.  If you would like some more
 *   examples, create a new game, and choose the "introductory" version
 *   when asked for the type of starter game to create.  
 */

/* 
 *   Include the main header for the standard TADS 3 adventure library.
 *   Note that this does NOT include the entire source code for the
 *   library; this merely includes some definitions for our use here.  The
 *   main library must be "linked" into the finished program by including
 *   the file "adv3.tl" in the list of modules specified when compiling.
 *   In TADS Workbench, simply include adv3.tl in the "Source Files"
 *   section of the project.
 *   
 *   Also include the US English definitions, since this game is written
 *   in English.  
 */
#include <adv3.h>
#include <en_us.h>

/*
 *   Game information writer.  Set up and write out the card-catalog
 *   information for the game.  This information is written to a file
 *   called GameInfo.txt during preinit, and can then be stored in the
 *   compiled .gam file for retrieval by automated tools.  This
 *   information is useful for archive maintainers and other searching and
 *   browsing tools.
 *   
 *   IMPORTANT - you must customize some of the text below, as marked.  
 */
PreinitObject
    execute()
    {
        local tab = new LookupTable();
        tab['Name'] = versionInfo.name;
        tab['Byline'] = versionInfo.byline;
        tab['HtmlByline'] = versionInfo.htmlByline;
        tab['AuthorEmail'] = versionInfo.authorEmail;
        tab['Version'] = versionInfo.version;
        tab['Desc'] = 'CUSTOMIZE - this should provide a brief
            description of the game, in plain text format.';
        tab['HtmlDesc'] = 'CUSTOMIZE - this should provide a brief
            description of the game, in HTML format.';
        tab['PresentationProfile'] = 'Multimedia';

        /* write the game information to GameInfo.txt */
        writeGameInfo(tab, 'GameInfo.txt');
    }
;

/*
 *   Our game credits and version information.  This object isn't required
 *   by the system, but our GameInfo initialization above needs this for
 *   some of its information.
 *   
 *   You should customize to provide the name of your game, your byline,
 *   and so on.  
 */
versionInfo: GameID
    name = 'TADS 3 Starter Game'
    byline = 'by An Author'
    htmlByline = 'by <a href="mailto:author@address.com">
                  An Author</a>'
    authorEmail = 'An Author <author@address.com>'
    version = '1.0'

    showCredit()
    {
        /* show our credits */
        "Put credits for the game here. ";

        /* 
         *   The game credits are displayed first, but the library will
         *   display additional credits for library modules.  It's a good
         *   idea to show a blank line after the game credits to separate
         *   them visually from the (usually one-liner) library credits
         *   that follow.  
         */
        "\b";
    }
    showAbout()
    {
        "Put information for players here.  Many authors like to mention
        any unusual commands here, along with background information on
        the game (for example, the author might mention that the game
        was created as an entry for a particular competition). ";
    }
;

/* 
 *   Starting location - we'll use this as the player character's initial
 *   location.  The name of the starting location isn't important to the
 *   library, but note that it has to match up with the initial location
 *   for the player character, defined in the "me" object below.
 *   
 *   Our definition defines two strings.  The first string, which must be
 *   in single quotes, is the "name" of the room; the name is displayed on
 *   the status line and each time the player enters the room.  The second
 *   string, which must be in double quotes, is the "description" of the
 *   room, which is a full description of the room.  This is displayed
 *   when the player types "look around," when the player first enters the
 *   room, and any time the player enters the room when playing in VERBOSE
 *   mode.  
 */
startRoom: Room 'Start Room'
    "This is the starting room. "
;

/*
 *   Define the player character.  The name of this object is not
 *   important, but note that it has to match up with the name we use in
 *   the main() routine to initialize the game, below.
 *   
 *   Note that we aren't required to define any vocabulary or description
 *   for this object, because the class Actor, defined in the library,
 *   automatically provides the appropriate definitions for an Actor when
 *   the Actor is serving as the player character.  Note also that we
 *   don't have to do anything special in this object definition to make
 *   the Actor the player character; any Actor can serve as the player
 *   character, and we'll establish this one as the PC in main(), below.  
 */
me: Actor
    /* the initial location */
    location = startRoom
;

/*
 *   Main entrypoint.  After the library finishes initializing, it calls
 *   this routine.  This function orchestrates the entire execution of the
 *   game; when this function returns, the program terminates.
 *   
 *   'args' contains a list of strings giving the command-line arguments
 *   that the player used to start the game from the operating system
 *   command shell.  At a minimum, this will contain one element giving
 *   the name of the image (.t3) file being executed.
 *   
 *   Our implementation here is simple: we display an introductory
 *   message, then we call runGame(), a library routine that does all of
 *   the work involved in running the game.  The runGame() function
 *   doesn't return until the game ends (for example, when the player
 *   types QUIT). 
 */
main(args)
{
    /* show our introductory message */
    "Welcome to the TADS 3 Starter Game!\b";

    /* set the initial player character to the "me" object */
    gPlayerChar = me;

    /* 
     *   Run the game, specifying that we want to show a full description
     *   of the player character's initial location. 
     */
    runGame(true);

    /* the game is now over - show our farewell message */
    "<.p>Thanks for playing!\b";
}
