/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.MARGINS;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.REBARBANDINFO;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TypedListener;

public class CoolItem
extends Item {
    CoolBar parent;
    Control control;
    int id;
    boolean ideal;
    boolean minimum;

    public CoolItem(CoolBar coolBar, int n) {
        super(coolBar, n);
        this.parent = coolBar;
        coolBar.createItem(this, coolBar.getItemCount());
    }

    public CoolItem(CoolBar coolBar, int n, int n2) {
        super(coolBar, n);
        this.parent = coolBar;
        coolBar.createItem(this, n2);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2) {
        this.checkWidget();
        int n3 = this.parent.indexOf(this);
        if (n3 == -1) {
            return new Point(0, 0);
        }
        int n4 = n;
        int n5 = n2;
        if (n == -1) {
            n4 = 32;
        }
        if (n2 == -1) {
            n5 = 32;
        }
        return new Point(n4 += this.parent.getMargin(n3), n5);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n2 = this.parent.handle;
        RECT rECT = new RECT();
        OS.SendMessage(n2, 1033, n, rECT);
        if (OS.COMCTL32_MAJOR >= 6) {
            MARGINS mARGINS = new MARGINS();
            OS.SendMessage(n2, 1064, 0, mARGINS);
            rECT.left -= mARGINS.cxLeftWidth;
            rECT.right += mARGINS.cxRightWidth;
        }
        if (!this.parent.isLastItemOfRow(n)) {
            rECT.right = rECT.right + ((this.parent.style & 0x800000) == 0 ? 2 : 0);
        }
        int n3 = rECT.right - rECT.left;
        int n4 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n3, n4);
    }

    Rectangle getClientArea() {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n2 = this.parent.handle;
        RECT rECT = new RECT();
        OS.SendMessage(n2, 1058, n, rECT);
        RECT rECT2 = new RECT();
        OS.SendMessage(n2, 1033, n, rECT2);
        int n3 = rECT2.left + rECT.left;
        int n4 = rECT2.top;
        int n5 = rECT2.right - rECT2.left - rECT.left;
        int n6 = rECT2.bottom - rECT2.top;
        if ((this.parent.style & 0x800000) == 0) {
            n4 += rECT.top;
            n5 -= rECT.right;
            n6 -= rECT.top + rECT.bottom;
        }
        if (n == 0) {
            REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
            rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
            rEBARBANDINFO.fMask = 2048;
            OS.SendMessage(n2, OS.RB_GETBANDINFO, n, rEBARBANDINFO);
            n5 = n5 - rEBARBANDINFO.cxHeader + 1;
        }
        return new Rectangle(n3, n4, n5, n6);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public CoolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
        this.parent = null;
    }

    public void setControl(Control control) {
        int n;
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((n = this.parent.indexOf(this)) == -1) {
            return;
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        Control control2 = this.control;
        Control control3 = control;
        int n2 = this.parent.handle;
        int n3 = 0;
        if (control3 != null) {
            n3 = control.handle;
        }
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 16;
        rEBARBANDINFO.hwndChild = n3;
        this.control = control3;
        int n4 = 0;
        if (control3 != null) {
            n4 = OS.GetWindow(n3, 3);
        }
        boolean bl = control3 != null && !control3.getVisible();
        boolean bl2 = control2 != null && control2.getVisible();
        OS.SendMessage(n2, OS.RB_SETBANDINFO, n, rEBARBANDINFO);
        if (bl) {
            control3.setVisible(false);
        }
        if (bl2) {
            control2.setVisible(true);
        }
        if (n4 != 0 && n4 != n3) {
            int n5 = 19;
            this.SetWindowPos(n3, n4, 0, 0, 0, 0, n5);
        }
    }

    public Point getPreferredSize() {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return new Point(0, 0);
        }
        int n2 = this.parent.handle;
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 544;
        OS.SendMessage(n2, OS.RB_GETBANDINFO, n, rEBARBANDINFO);
        int n3 = rEBARBANDINFO.cxIdeal + this.parent.getMargin(n);
        return new Point(n3, rEBARBANDINFO.cyMinChild);
    }

    public void setPreferredSize(int n, int n2) {
        this.checkWidget();
        int n3 = this.parent.indexOf(this);
        if (n3 == -1) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.max(0, n2);
        this.ideal = true;
        int n4 = this.parent.handle;
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 32;
        OS.SendMessage(n4, OS.RB_GETBANDINFO, n3, rEBARBANDINFO);
        rEBARBANDINFO.fMask = 544;
        rEBARBANDINFO.cxIdeal = Math.max(0, n - this.parent.getMargin(n3));
        rEBARBANDINFO.cyMaxChild = n2;
        if (!this.minimum) {
            rEBARBANDINFO.cyMinChild = n2;
        }
        OS.SendMessage(n4, OS.RB_SETBANDINFO, n3, rEBARBANDINFO);
    }

    public void setPreferredSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setPreferredSize(point.x, point.y);
    }

    public Point getSize() {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            new Point(0, 0);
        }
        int n2 = this.parent.handle;
        RECT rECT = new RECT();
        OS.SendMessage(n2, 1033, n, rECT);
        if (OS.COMCTL32_MAJOR >= 6) {
            MARGINS mARGINS = new MARGINS();
            OS.SendMessage(n2, 1064, 0, mARGINS);
            rECT.left -= mARGINS.cxLeftWidth;
            rECT.right += mARGINS.cxRightWidth;
        }
        if (!this.parent.isLastItemOfRow(n)) {
            rECT.right = rECT.right + ((this.parent.style & 0x800000) == 0 ? 2 : 0);
        }
        int n3 = rECT.right - rECT.left;
        int n4 = rECT.bottom - rECT.top;
        return new Point(n3, n4);
    }

    public void setSize(int n, int n2) {
        this.checkWidget();
        int n3 = this.parent.indexOf(this);
        if (n3 == -1) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.max(0, n2);
        int n4 = this.parent.handle;
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 544;
        OS.SendMessage(n4, OS.RB_GETBANDINFO, n3, rEBARBANDINFO);
        if (!this.ideal) {
            rEBARBANDINFO.cxIdeal = Math.max(0, n - this.parent.getMargin(n3));
        }
        if (!this.minimum) {
            rEBARBANDINFO.cyMinChild = n2;
        }
        rEBARBANDINFO.cyChild = rEBARBANDINFO.cyMaxChild = n2;
        if (!this.parent.isLastItemOfRow(n3)) {
            if (OS.COMCTL32_MAJOR >= 6) {
                MARGINS mARGINS = new MARGINS();
                OS.SendMessage(n4, 1064, 0, mARGINS);
                n -= mARGINS.cxLeftWidth;
                n -= mARGINS.cxRightWidth;
            }
            int n5 = (this.parent.style & 0x800000) == 0 ? 2 : 0;
            rEBARBANDINFO.cx = n - n5;
            rEBARBANDINFO.fMask |= 0x40;
        }
        OS.SendMessage(n4, OS.RB_SETBANDINFO, n3, rEBARBANDINFO);
    }

    public void setSize(Point point) {
        if (point == null) {
            this.error(4);
        }
        this.setSize(point.x, point.y);
    }

    public Point getMinimumSize() {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return new Point(0, 0);
        }
        int n2 = this.parent.handle;
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 32;
        OS.SendMessage(n2, OS.RB_GETBANDINFO, n, rEBARBANDINFO);
        return new Point(rEBARBANDINFO.cxMinChild, rEBARBANDINFO.cyMinChild);
    }

    public void setMinimumSize(int n, int n2) {
        this.checkWidget();
        int n3 = this.parent.indexOf(this);
        if (n3 == -1) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.max(0, n2);
        this.minimum = true;
        int n4 = this.parent.handle;
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 32;
        OS.SendMessage(n4, OS.RB_GETBANDINFO, n3, rEBARBANDINFO);
        rEBARBANDINFO.cxMinChild = n;
        rEBARBANDINFO.cyMinChild = n2;
        OS.SendMessage(n4, OS.RB_SETBANDINFO, n3, rEBARBANDINFO);
    }

    public void setMinimumSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setMinimumSize(point.x, point.y);
    }

    boolean getWrap() {
        int n = this.parent.indexOf(this);
        int n2 = this.parent.handle;
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 1;
        OS.SendMessage(n2, OS.RB_GETBANDINFO, n, rEBARBANDINFO);
        return (rEBARBANDINFO.fStyle & 1) != 0;
    }

    void setWrap(boolean bl) {
        int n = this.parent.indexOf(this);
        int n2 = this.parent.handle;
        REBARBANDINFO rEBARBANDINFO = new REBARBANDINFO();
        rEBARBANDINFO.cbSize = REBARBANDINFO.sizeof;
        rEBARBANDINFO.fMask = 1;
        OS.SendMessage(n2, OS.RB_GETBANDINFO, n, rEBARBANDINFO);
        rEBARBANDINFO.fStyle = bl ? (rEBARBANDINFO.fStyle |= 1) : (rEBARBANDINFO.fStyle &= 0xFFFFFFFE);
        OS.SendMessage(n2, OS.RB_SETBANDINFO, n, rEBARBANDINFO);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }
}

