package test.themes;

import java.awt.FlowLayout;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.utils.SubstanceConstants.FocusKind;

public class State extends JFrame {
	public State() {
		super("Control states");
		this.setLayout(new FlowLayout());
		
		JButton button1 = new JButton("active");
		button1.putClientProperty(SubstanceLookAndFeel.PAINT_ACTIVE_PROPERTY, Boolean.TRUE);
		JButton button2 = new JButton("default");
		JButton button3 = new JButton("disabled");
		button3.setEnabled(false);
		
		this.add(button1);
		this.add(button2);
		this.add(button3);
		
		this.pack();
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}
	
	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		UIManager.put(SubstanceLookAndFeel.FOCUS_KIND, FocusKind.NONE);
		new State().setVisible(true);
	}
	
}
