package test.contrib.combotheme;

import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

import javax.swing.*;

import org.jvnet.lafwidget.LafWidget;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.border.GlassBorderPainter;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.painter.AlphaControlBackgroundComposite;
import org.jvnet.substance.painter.SimplisticGradientPainter;
import org.jvnet.substance.painter.decoration.ArcDecorationPainter;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.skin.SubstanceAbstractSkin;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.theme.SubstanceTheme.ThemeKind;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.watermark.SubstanceNoneWatermark;

public class ComboBoxTestNew extends JFrame {

	public static void main(String[] args) {
		try {
			initLaF();
		} catch (UnsupportedLookAndFeelException e) {
			System.out.println(e);
		}

		SwingUtilities.invokeLater(new Runnable() {

			public void run() {
				new ComboBoxTestNew("Test");
			}
		});
	}

	protected static class CustomSkin extends SubstanceAbstractSkin {
		public String getDisplayName() {
			return "Custom";
		}

		public CustomSkin() {
			super();
			// DefaultTheme
			Color[] colors = { Color.white, new Color(150, 150, 150),
					new Color(170, 170, 170), new Color(130, 130, 130),
					new Color(100, 100, 100), new Color(76, 76, 76),
					new Color(101, 101, 101) };
			SubstanceTheme tintedRaven = new ColorTheme("DefaultTheme", colors);
			// active Theme
			Color[] activeColors = { Color.white, new Color(170, 170, 232),
					new Color(165, 165, 212), new Color(117, 120, 232),
					new Color(100, 100, 100), new Color(76, 76, 76),
					new Color(101, 101, 101) };
			SubstanceTheme active = new ColorTheme("ActiveTheme", activeColors);
			// disabled ColorScheme:
			Color[] disabledColors = { new Color(167, 167, 167),
					new Color(150, 150, 150), new Color(170, 170, 170),
					new Color(130, 130, 130), new Color(100, 100, 100),
					new Color(76, 76, 76), new Color(101, 101, 101) };
			SubstanceTheme disabled = new ColorTheme("DisabledTheme",
					disabledColors);

			this.theme = new SubstanceComplexTheme("all", ThemeKind.DARK,
					active, tintedRaven, disabled, tintedRaven
							.getActiveTitlePaneTheme()) {
				@Override
				public Color getSelectionBackgroundColor() {
					return new Color(170, 170, 232);
				}
			};

			this.buttonShaper = new ClassicButtonShaper();
			this.gradientPainter = new SimplisticGradientPainter();
			this.watermark = new SubstanceNoneWatermark();
			this.decorationPainter = new ArcDecorationPainter();
			this.highlightPainter = new ClassicHighlightPainter();
			tabBackgroundComposite = new AlphaControlBackgroundComposite(0.5f);
			this.borderPainter = new GlassBorderPainter();
		}
	}

	protected static class MyCustomLookAndFeel extends SubstanceLookAndFeel {
		@Override
		public String getID() {
			return "Custom";
		}

		@Override
		public String getName() {
			return "Custom";
		}

		@Override
		public void initialize() {
			super.initialize();
			setSkin(new CustomSkin());
		}
	}

	public static void initLaF() throws UnsupportedLookAndFeelException {
		UIManager.setLookAndFeel(new MyCustomLookAndFeel());

		UIManager.put(SubstanceLookAndFeel.FOCUS_KIND,
				SubstanceConstants.FocusKind.NONE);

		UIManager.put(SubstanceLookAndFeel.BUTTON_NO_MIN_SIZE_PROPERTY,
				Boolean.TRUE);

		UIManager.put(LafWidget.COMBO_BOX_NO_AUTOCOMPLETION, Boolean.TRUE);
	}

	public ComboBoxTestNew(String title) {
		super(title);
		initGUI();
		setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		addWindowListener(new WindowAdapter() {

			@Override
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});
		pack();
		setLocationRelativeTo(null);
		setVisible(true);
	}

	private void initGUI() {
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		Vector<String> boxVector = new Vector<String>();
		boxVector.add("Test 1");
		boxVector.add("Test 2");
		JComboBox comboBox = new JComboBox(boxVector);
		comboBox.setFont(new Font("Verdana", Font.PLAIN, 16));
		comboBox.setEditable(true);
		panel.add(comboBox, BorderLayout.CENTER);
		getContentPane().add(panel);
	}
}
