/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.skin;

import org.jvnet.substance.border.ClassicBorderPainter;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.MetallicColorScheme;
import org.jvnet.substance.color.SteelBlueColorScheme;
import org.jvnet.substance.painter.*;
import org.jvnet.substance.painter.decoration.*;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.theme.*;
import org.jvnet.substance.theme.SubstanceTheme.ThemeKind;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.watermark.SubstanceNullWatermark;

/**
 * <code>Business Black Steel</code> skin. This class is part of officially
 * supported API.
 * 
 * @author Kirill Grouchnikov
 * @since version 3.3
 */
public class BusinessBlackSteelSkin extends SubstanceAbstractSkin {
	/**
	 * Display name for <code>this</code> skin.
	 */
	public static String NAME = "Business Black Steel";

	/**
	 * Creates a new <code>Business</code> skin.
	 */
	public BusinessBlackSteelSkin() {
		SubstanceTheme activeTheme = new SubstanceTheme(
				new SteelBlueColorScheme(), "Tint Steel Blue", ThemeKind.COLD)
				.tint(0.15);
		SubstanceTheme defaultTheme = new SubstanceTheme(
				new MetallicColorScheme(), "Tint Metallic", ThemeKind.COLD)
				.tint(0.05);
		SubstanceTheme disabledTheme = defaultTheme.getDisabledTheme();
		SubstanceTheme activeTitleTheme = new SubstanceEbonyTheme();

		SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME,
				ThemeKind.COLD, activeTheme, defaultTheme, disabledTheme,
				activeTitleTheme);
		// theme.setCellRendererBackgroundTheme(new SubstanceBlendBiTheme(
		// new SubstanceTerracottaTheme(), new SubstanceSunGlareTheme(),
		// 0.5).tint(0.2));

		theme.registerComponentHighlightStateTheme(activeTheme, 0.6f,
				ComponentState.ROLLOVER_UNSELECTED);
		theme.registerComponentHighlightStateTheme(activeTheme, 0.8f,
				ComponentState.SELECTED);
		theme.registerComponentHighlightStateTheme(activeTheme, 0.95f,
				ComponentState.ROLLOVER_SELECTED);
		theme.registerComponentHighlightStateTheme(activeTheme, 0.8f,
				ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);

		SubstanceComplexTheme decorationTheme = new SubstanceComplexTheme(
				"Business Black Steel Decoration", ThemeKind.DARK,
				activeTitleTheme.shade(0.3), activeTitleTheme, disabledTheme);
		theme.registerDecorationAreaTheme(decorationTheme, true,
				DecorationAreaType.PRIMARY_TITLE_PANE,
				DecorationAreaType.SECONDARY_TITLE_PANE);

		theme.registerDecorationAreaTheme(activeTitleTheme, false,
				DecorationAreaType.HEADER);

		SubstanceComplexTheme generalDecorationTheme = new SubstanceComplexTheme(
				"Business Black Steel General Decoration", ThemeKind.DARK,
				activeTheme.shade(0.1).saturate(-0.5), activeTheme.tint(0.3)
						.saturate(-0.7), disabledTheme);
		generalDecorationTheme.registerComponentStateTheme(disabledTheme, 0.5f,
				false, ComponentState.DISABLED_UNSELECTED);
		theme.registerDecorationAreaTheme(generalDecorationTheme, true,
				DecorationAreaType.GENERAL);

		theme.setSelectedTabFadeStart(0.1);
		theme.setSelectedTabFadeEnd(0.3);
		theme
				.setNonActivePainter(new SimplisticSoftBorderReverseGradientPainter());
		theme.setDefaultTitlePaneTheme(activeTitleTheme);

		theme.setPaintingToolbarDropShadows();

		this.theme = theme;
		// theme.addPaintAsActive(JScrollBar.class);
		this.buttonShaper = new ClassicButtonShaper();
		this.watermark = new SubstanceNullWatermark();
		this.gradientPainter = new ClassicGradientPainter();
		this.borderPainter = new ClassicBorderPainter();

		BrushedMetalDecorationPainter decorationPainter = new BrushedMetalDecorationPainter();
		decorationPainter.setBaseDecorationPainter(new ArcDecorationPainter());
		decorationPainter.setTextureAlpha(0.02f);
		this.decorationPainter = decorationPainter;

		this.highlightPainter = new ClassicHighlightPainter();

		this.tabBackgroundComposite = new AlphaControlBackgroundComposite(0.5f);

		this.borderPainter = new ClassicBorderPainter();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.skin.SubstanceSkin#getDisplayName()
	 */
	public String getDisplayName() {
		return NAME;
	}
}
