/* OS-dependent support for fine-grained timer.
** Copyright (c) 1995 by Olin Shivers.
**
** We return the current time in seconds and sub-second "ticks" where the 
** number of ticks/second is OS dependent (and is defined in time_dep.scm).
** This definition works on any BSD Unix with the gettimeofday() 
** microsecond-resolution timer.
*/

#include <errno.h>
#include <sys/time.h>
#include "scheme48.h"
#include "../time1.h"

s48_value time_plus_ticks()
{
    struct timeval t;
    struct timezone tz;

    if( gettimeofday(&t, &tz) ) s48_raise_os_error (errno);

    return   s48_cons (s48_enter_integer (t.tv_sec),
		       s48_cons (s48_enter_integer (t.tv_usec), S48_NULL));
}
