.TH "close" 2 " 04 June 1998" "Fractales Group" "Scilab Function"
.SH NAME
close - close a figure
.SH CALLING SEQUENCE
close(h)
.SH PARAMETERS
.TP
o 
h : integer
Handle of the window to close

.SH Description
This routine close a tksci figure (toplevel window). If a handle is 
given, the figure corresponding to this handle is closed. 
Otherwise, the current (active) figure is closed.
.SH EXAMPLE
.nf
h=figure();
// creates  figure number 1.  
uicontrol( h, 'style','text', ...
 'string','scilab is great', ...
 'position',[50 70 100 100], ...
 'fontsize',15);
// put a clever text in figure 1
figure();
// create figure 2
uicontrol( 'style','text', ...
 'string','Really great', 'position',[50 70 100 100], 'fontsize',15);
// put a text in figure 2
close();
// close the current graphic window (ie fig. 2)
close(h);
// close figure 1
.fi 
.SH SEE ALSO
figure, gcf
.SH AUTHOR
Bertrand Guiheneuf
