.TH "TK_EvalStr" 2 " 04 June 1998" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
TK_EvalStr - Evaluate a string whithin the  tcl/tk interpreter
.SH CALLING SEQUENCE
.nf
TK_EvalStr(str)
.fi
.SH PARAMETERS
.TP 5
str 
: string or vector of strings, contains the tcl/tk instructions

.SH Description
This routine allows to evaluate tcl/tk  instructions with the tcl/tk
interpreter launched with scilab. 

When tcl/tk support is enabled in scilab, you can evaluate tcl/tk expression
from scilab interpreter. In fact, scilab launches a slave tcl/tk interpreter.
The scilab instruction \fBTK_EvalStr()\fP can be used to evaluate expression 
without having to write a tcl/tk in a separated file (this is done using 
TK_EvalFile). 
.SH AUTHOR
Bertrand Guiheneuf

.SH EXAMPLE
.nf
//with one call
TK_EvalStr(['toplevel .foo1'
   'label .foo1.l -text ""TK married Scilab !!!""'
   'pack .foo1.l'
   'button .foo1.b -text close -command {destroy .foo1}'
   'pack .foo1.b'])

//step by step (debugging)
TK_EvalStr('toplevel .foo2');
// creates a toplevel TK window. 
TK_EvalStr('label .foo2.l -text ""TK married Scilab !!!""');
// create a static label
TK_EvalStr('pack .foo2.l');
// pack the label widget. It appears on the screen.
text='button .foo2.b -text close -command {destroy .foo2}';
TK_EvalStr(text);
TK_EvalStr('pack .foo2.b');
.fi 
.SH SEE ALSO
ScilabEval, TK_EvalFile, TK_GetVar, TK_Setvar
