.TH wavwrite 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
wavwrite - writes .wav sound file
.SH CALLING SEQUENCE
.nf
wavwrite(y,wavfile)
wavwrite(y,Fs,wavfile)
wavwrite(y,Fs,bits,wavfile)
.fi
.SH PARAMETERS
.TP
y
: real vector or matrix with entries in [-1,1].
.TP
wavfile
: string (The .wav extension is appended if no extension is given)
.TP
Fs
: integer, frequency sampling in Hz.
.TP
bits
: integer, number of bits in the encoding.
.TP
method
: string , \fV'mu'\fR (default) or \fV'linear'\fR, encoding method.
.SH DESCRIPTION
Utility function to save \fV.wav\fR sound file.
\fVwavwrite(y,wavfile)\fR writes a sound file specified by the
string wavfile.  The data should be arranged with one channel
per column.  Amplitude values outside the range [-1,+1] are
ignored.
Supports multi-channel data for 8-bit mu-law, and 8- and 16-bit linear formats.

\fVwavwrite(y,Fs,wavfile)\fR specifies in \fVFs\fR the sample rate of the data
in Hertz.

\fVwavwrite(y,Fs,bits,wavfile)\fR selects the number of bits in
the encoder.  Allowable settings are bits=8 and bits=16.
 
.SH SEE ALSO
auread, wavread, savewave,  analyze, mapsound
