.TH lincos  "May 2000" "Scilab Group" "Scicos function"
.so ../sci.an
.SH NAME
lincos - linearizes a system described by a scicos diagram
.SH CALLING SEQUENCE
.nf
sys= lincos(scs_m [,x0,u0 [,param] ])
.fi
.SH PARAMETERS
.TP 10
scs_m
: a Scicos data structure
.TP
x0
: column vector. Continuous state around which linearization to be
done (default 0)
.TP
u0
: column vector. Input around which linearization to be done (default 0)
.TP
state
: state of scicos diagram
.TP
param
: list with two elements (default \fVlist(1.d-6,0)\fR)
.RS
.TP
param(1)
: scalar. Perturbation level for linearization; the
following variation is used  
\fVdel([x;u])_i = param(1)+param(1)*1d-4*abs([x;u])\fR
.TP
param(2)
: scalar. Time t
.RE
.TP
sys
: state-space linear model
.SH DESCRIPTION
Constructs by linearization a linear state-space model from a general
dynamical system described by a scicos diagram.
.TP
.SH SEE ALSO
scicos, scicos_main, steadycos
.SH EXAMPLE
.nf
.fi
.SH AUTHOR
R. Nikoukhah
