.TH pvm_reduce 1 "May 1998" "Scilab // Group" "Scilab function"
.so ../sci.an
.SH NAME
pvm_reduce - Performs a reduce operation over members of the specified
group.
.SH CALLING SEQUENCE
.nf
[buff, info] = pvm_reduce(func, buff, msgtag, group, rootginst)
.fi
.SH PARAMETERS
.TP 5
func :  string, defines the  operation performed  on  the global
data. Should be : Max, Min, Sum or Pro.
.TP 5
buff : scalar,  local scilab variable.  On  return, the  data array on
the root will  be overwritten with the result  of the reduce operation
over the group.
.TP 7
msgtag : integer, message tag supplied by the user.  msgtag
             should  be  >=  0.   It allows the user's program to
             distinguish between different kinds of messages.
.TP 6
group : string, group name of an existing group.
.TP 6
rootginst  :  integer, instance number  of  group member who  gets the
result.   
.TP 6
info : integer, status code returned by the routine.  Values
             less than zero indicate an error.

.SH DESCRIPTION
\fVpvm_reduce\fR performs global operations such as max, min,
     sum or product over  all  the tasks in a group. All group members
     call pvm_reduce with their local data, and the  result  of
     the  reduction  operation appears on the user specified root
     task root. The root  task  is  identified  by  its  instance
     number in the group.

Max and Min are implemented for scalar datatypes (double, complex). 
     For complex values the minimum  [maximum]  is  that  complex
     pair with  the  minimum [maximum] modulus.    Sum and Product are
implemented for scalar datatypes. 


Note:  pvm_reduce  does  not  block.   If  a  task   calls
     pvm_reduce  and  then  leaves  the group before the root has
     called pvm_reduce an error may occur.


.SH EXAMPLE
.nf
A = rand(5,5);
[buff, info] = pvm_reduce("Max", A, msgtag, "Workers", 0)
.fi
.SH SEE ALSO
pvm_bcast, pvm_barrier, pvm_psend, pvm_getinst, pvm_gsize,
pvm_joingroup, pvm_lvgroup
