.TH for 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
for - language keyword for loops
.SH DESCRIPTION
Used to define loops. Its syntax is:
.LP
.Vb for variable=expression ,instruction,   ,instruction,end
.LP
.Vb for variable=expression do instruction,   ,instruction,end
.LP
If  \fVexpression\fR is a matrix or a row vector, \fVvariable\fR
takes as values the values of each column of the matrix.
.LP
Useful example : \fVfor variable=n1:step:n2,  ...,end\fR
.LP
If \fVexpression\fR is a list \fVvariable\fR takes as values the
successive entries of the list.
.LP
Warning: the number of characters used to define the body of any
conditionnal instruction (if while for or select/case) must be limited to
16k.

.SH EXAMPLE
.nf
n=5;
for i = 1:n, for j = 1:n, a(i,j) = 1/(i+j-1);end;end
for j = 2:n-1, a(j,j) = j; end; a
for  e=eye(3,3),e,end  
for v=a, write(6,v),end        
for j=1:n,v=a(:,j), write(6,v),end 
for l=list(1,2,'example'); l,end 
.fi
