.TH genmarkov 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
genmarkov - generates random markov matrix with recurrent and transient classes
.SH CALLING SEQUENCE
.nf
M=genmarkov(rec,tr)
M=genmarkov(rec,tr,flag)
.fi
.SH PARAMETERS
.TP 10
rec
: integer row vector (its dimension is the number of recurrent classes).
.TP 10
tr
: integer (number of transient states)
.TP 10
M
: real Markov matrix. Sum of entries in each row should add to one.
.TP
flag
: string \fV'perm'\fR. If given, a random permutation of the states is done.
.SH DESCRIPTION
Returns in M a random Markov transition probability matrix
with \fVsize(rec,1)\fR recurrent classes with \fVrec(1),...rec($)\fR 
entries respectively and tr transient states.
.SH EXAMPLE
.nf
//P has two recurrent classes (with 2 and 1 states) 2 transient states
P=genmarkov([2,1],2,'perm')
[perm,rec,tr,indsRec,indsT]=classmarkov(P);
P(perm,perm)
.fi
.SH SEE ALSO
classmarkov, eigenmarkov




