.TH xstringl 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
xstringl - compute a box which surrounds strings
.SH CALLING SEQUENCE
.nf
rect=xstringl(x,y,str)
.fi
.SH PARAMETERS 
.TP 6
rect 
: vector of 4 real scalars defining the box.
.TP
x,y
: real scalars, coordinates of the lower-left point of the strings.
.TP
str
: matrix of strings.
.SH DESCRIPTION
\fVxstringl\fR returns in \fVrect=[x,y,w,h]\fR 
(upper-left point, width, height)
the size of a rectangle in the current graphic scale which
would surround the strings \fVstr\fR drawn at location \fVx,y\fR
(lower-left point).

The result can be approximative when using the Postscript driver.
.SH EXAMPLE
.nf
plot2d([0;1],[0;1],0)
str=["Scilab" "is";"not" "elisaB"];
r=xstringl(0.5,0.5,str)
xrects([r(1) r(2)+r(4) r(3) r(4)]')
xstring(r(1),r(2),str)
.fi
.SH SEE ALSO
titlepage, xstring, xstringl, xtitle
.SH AUTHOR
J.Ph.C.
