.TH plot3d1 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
plot3d1 - 3D gray or color level plot of a surface
.SH DESCRIPTION
.nf
plot3d1(x,y,z,[theta,alpha,leg,flag,ebox])
plot3d1(xf,yf,zf,[theta,alpha,leg,flag,ebox])
.fi
.SH PARAMETERS
See \fVplot3d\fR for a full description. There is just a slight
difference, only the sign of the \fVflag(1)=mode\fR parameter is used:
if it is negative the grid is not drawn. 
.SH DESCRIPTION
\fVplot3d\fR plots a surface \fVz=f(x,y)\fR
with colors depending on the z-level of the surface.

Enter the command \fVplot3d1()\fR to see a demo.
.SH EXAMPLE 
.nf
// simple plot using z=f(x,y)
t=[0:0.3:2*%pi]'; z=sin(t)*cos(t');
plot3d1(t,t,z)
// same plot using facets computed by genfac3d
[xx,yy,zz]=genfac3d(t,t,z);
xbasc()
plot3d1(xx,yy,zz)
// multiple plots
xbasc()
plot3d1([xx xx],[yy yy],[zz 4+zz])
// simple plot with viewpoint and captions
xbasc()
plot3d1(1:10,1:20,10*rand(10,20),35,45,"X@Y@Z",[2,2,3])
// same plot without grid
xbasc()
plot3d1(1:10,1:20,10*rand(10,20),35,45,"X@Y@Z",[-2,2,3])
// plot of a sphere using facets computed by eval3dp
deff("[x,y,z]=sph(alp,tet)",["x=r*cos(alp).*cos(tet)+orig(1)*ones(tet)";..
  "y=r*cos(alp).*sin(tet)+orig(2)*ones(tet)";..
  "z=r*sin(alp)+orig(3)*ones(tet)"]);
r=1; orig=[0 0 0];
[xx,yy,zz]=eval3dp(sph,linspace(-%pi/2,%pi/2,40),linspace(0,%pi*2,20));
xbasc()
plot3d1(xx,yy,zz)
.fi
.SH SEE ALSO
plot3d
.SH AUTHOR
J.Ph.C.
