.TH param3d1 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
param3d1 - 3D plot of curves
.SH CALLING SEQUENCE
.nf
param3d1(x,y,z,[theta,alpha,leg,flag,ebox])
param3d1(x,y,list(z,colors),[theta,alpha,leg,flag,ebox])
.fi
.SH PARAMETERS
.TP 13
x,y,z
: matrices of the same size (nl,nc). Each column i of the 
matrices corresponds to the coordinates of the ith curve.

You can give a specific 
color for each curve by using \fVlist(z,colors)\fR instead of \fVz\fR,
where \fVcolors\fR is a vector of size \fVnc\fR. If \fVcolor(i)\fR is negative
the curve is plotted using the mark with id 
\fVabs(style(i))+1\fR; if \fVstyle(i)\fR is strictly positive, a plain line 
with color id \fVstyle(i)\fR or a dashed line with dash id \fVstyle(i)\fR is 
used. Use \fVxset()\fR to see the mark and color ids.
.TP
theta,alpha
: real values giving in degree the  spherical coordinates of the 
observation point.
.TP
leg
: string defining the captions for each axis with @ as  a  field  separator,
for  example "X@Y@Z".
.TP
flag=[type,box]
: \fVtype\fR and \fVbox\fR have the same meaning as in \fVplot3d\fR.
.RS 
.TP 5
type 
: an integer (scaling).
.RS 
.TP 8
type=0
the plot is made using the current 3D scaling (set by a previous call to
\fVparam3d\fR, \fVplot3d\fR, \fVcontour\fR or \fVplot3d1\fR).
.TP
type=1
rescales
automatically 3d boxes with extreme aspect ratios, the boundaries are specified by the value of the optional argument \fVebox\fR.
.TP
type=2
rescales
automatically 3d boxes with extreme aspect ratios, the boundaries are computed using the given data.
.TP
type=3
3d isometric with box bounds given by optional
\fVebox\fR, similarily to \fVtype=1\fR
.TP
type=4
3d isometric bounds  derived from the data, to similarily\fVtype=2\fR
.TP
type=5
3d expanded isometric bounds  with box bounds given by optional
\fVebox\fR, similarily to \fVtype=1\fR
.TP
type=6
3d expanded isometric bounds  derived from the data, similarily to \fVtype=2\fR
.RE
.TP
box
: an integer (frame around the plot).
.RS
.TP
box=0 
nothing is drawn around the plot.
.TP
box=1 
unimplemented (like box=0).
.TP
box=2 
only the axes behind the surface are drawn.
.TP
box=3 
a box surrounding the surface is drawn and captions are added.
.TP
box=4
a box surrounding the surface is drawn, captions and axes are added.
.RE
.RE
.TP
ebox
: used when \fVtype\fR in \fVflag\fR is 1. It specifies the boundaries
of the plot as the vector \fV[xmin,xmax,ymin,ymax,zmin,zmax]\fR.
.SH DESCRIPTION 
\fVparam3d1\fR is used to plot 3D curves defined by their coordinates \fVx\fR,
\fVy\fR and \fVz\fR.

Enter the command \fVparam3d1()\fR to see a demo.
.SH EXAMPLE 
.nf
t=[0:0.1:5*%pi]';
param3d1([sin(t),sin(2*t)],[cos(t),cos(2*t)],..
	 list([t/10,sin(t)],[3,2]),35,45,"X@Y@Z",[2,3])
.fi
.SH SEE ALSO
param3d, plot3d, xset
.SH AUTHOR
J.Ph.C.
