.TH fcontour 2 "April 1993" "Scilab Group" "Scilab Function" 
.so ../sci.an
.SH NAME
fcontour - level curves on a 3D surface defined by a function
.SH CALLING SEQUENCE
.nf
fcontour(xr,yr,f,nz,[theta,alpha,leg,flag,ebox,zlev])
fcontour(xr,yr,f,nz,<opt_args>)
.fi
.SH PARAMETERS
.TP 7
xr,yr 
: two real row vectors of size n1 and n2.
.TP
f
: is an external which defines the surface
\fVz=f(x,y)\fR. It is first computed on the grid specified by
\fVxr,yr\fR. Then, control is passed to the routine \fVcontour\fR.
.TP
nz,
: see \fVcontour\fR.
.TP
theta,alpha,leg,flag,ebox,zlev
: see \fVcontour\fR.
.TP
<opt_args>
: see \fVcontour\fR.
.SH DESCRIPTION
Draws level curves of a surface \fVz=f(x,y)\fR. The level curves are
drawn on a 3D surface. The surface is given by the external function
\fVf\fR. See \fVcontour\fR.

.LP
The optional arguments \fVtheta,alpha,leg ,flag,ebox, zlev\fR, can be
passed by a sequence of statements \fVkey1=value1, key2=value2\fR,
... where keys may be \fVtheta\fR,\fValpha\fR,\fVleg\fR,\fV
flag\fR,\fVebox\fR,\fVzlev\fR. In this case, the order has no special
meaning.
.LP
Enter the command \fVfcontour()\fR to see a demo.
.SH EXAMPLE
.nf
deff("[z]=surf(x,y)","z=sin(x)*cos(y)");
t=%pi*[-10:10]/10;

fcontour(t,t,surf,10)

xbasc();fcontour(t,t,surf,10,ebox=[-4 4 -4 4 -1 1],zlev=-1,flag=[0 1 4])
.fi
.SH SEE ALSO
contour, contour2d, fcontour2d
.SH AUTHOR
J.Ph.C.
