.TH contour2di 2 "sept 2000" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
contour2di - compute level curves of a surface on a 2D plot
.SH CALLING SEQUENCE
.nf
[xc,yc]=contour2di(x,y,z,nz)
.fi
.SH PARAMETERS
.TP 5
x,y 
: two real row vectors of size n1 and n2: the grid.
.TP 5
z   
: real matrix of size (n1,n2), the values of the function.
.TP 5
nz 
: the level values or the number of levels.
.RS
.TP 3
-
If \fVnz\fR is an integer, its value gives the number of level curves 
equally spaced from zmin to zmax as follows:
.nf
 z= zmin + (1:nz)*(zmax-zmin)/(nz+1)
.fi
Note that the \fVzmin\fR and \fVzmax\fR levels are not drawn 
(generically they are reduced to points) but they can be added 
with 
.nf 
 [im,jm] = find(z == zmin);     // or zmax 
 plot2d(x(im)',y(jm)',-9,"000")
.fi 

-
If \fVnz\fR is a vector, \fVnz(i)\fR gives the value of the ith level curve.
.RE
.TP 5
xc,yc
: vectors of identical sizes containing the contours definitions. See
below for details.
.SH DESCRIPTION
\fVcontour2di\fR computes level curves of a surface \fVz=f(x,y)\fR on
a 2D plot.  The values of \fVf(x,y)\fR are given by the matrix \fVz\fR
at the grid points defined by \fVx\fR and \fVy\fR.

\fVxc(1)\fR contains the level associated with first contour path,
\fVyc(1)\fR contains the number \fVN1\fR of points defining this contour path
and (\fVxc(1+(1:N1))\fR, \fVyc(1+(1:N1))\fR ) contain the coordinates
of the paths points.
The second path begin at \fVxc(2+N1)\fR and \fVyc(2+N1)\fR and so on.
.SH EXAMPLE
.nf
[xc,yc]=contour2di(1:10,1:10,rand(10,10),5);
k=1;n=yc(k);c=1;
while k+yc(k)<size(xc,'*')
  n=yc(k);
  plot2d(xc(k+(1:n)),yc(k+(1:n)),c)
  c=c+1;
  k=k+n+1;
end

.fi
.SH SEE ALSO
contour, fcontour, fcontour2d, contour2d, plot2d, xset
.SH AUTHOR
J.Ph.C.
