.TH functions 1 "April 1993" "Scilab Group" "Scilab Data type"
.so ../sci.an
.SH NAME
functions - Scilab procedures and Scilab objects
.SH DESCRIPTION
Functions are Scilab procedures ("macro", "function" and "procedure"
have the save meaning). 
.SH FUNCTION DEFINITION
Usually, they are defined in files with an
editor and loaded into Scilab by \fVgetf\fR or through a library (see
\fVlib\fR or \fVgenlib\fR). But They can also be defined on-line (see
\fVdeff\fR or \fVfunction\fR o.

A function is defined by two components: 
.TP
-
a "syntax definition" part  as follows:
.nf 
 [y1,...,yn]=foo(x1,...,xm)
 [y1,...,yn,varargout]=foo(x1,...,xm,varargin)
.fi
.TP
- 
 a sequence of scilab instructions.
.RE


The "syntax definition" line gives the "full" calling syntax of this
function. The \fVyi\fR are output variables calculated as functions of
input variables \fVxi\fR and variables existing in Scilab when the
function is executed. 
.SH CALLING FUNCTION
Usually function calling syntax is
\fV[y1,...,yn]=foo(x1,...,xm)\fR. Shorter input or output argument
list than definition ones may be used. In such cases, only the first
variables from the left are used of set. The \fVargn\fR function may
be used to get the actual number of calling arguments.
.LP
It is also possible to use "named argument" to specify input
arguments: suppose function \fVfun1\fR defined as
\fVy1=fun1(x1,x2,x3)\fR then it call be called with a syntax like 
\fVy=fun1(x1=33,x3=[1 2 3])\fR within \fVfun1\fR x2 will be
undefined. It is possible to check for defined variables with the
\fVexists\fV function
.LP
When a function has no left hand side argument and is called only with
character string arguments, the callling syntax may be simplified
\fVfun('a','toto','a string')\fR can be replaced by \fVfun a toto 'a
string'\fR

.SH MISCELLANEOUS
Functions are Scilab objects (with type numbers 13 or 11). They and
can be manipulated (built, saved, loaded, passed as arguments,..) as
other variable types.
.LP
Collections of functions can be collected in libraries.  Functions
which begin with \fV%\fR sign (e.g. \fV%foo\fR) are often used to
overload (see \fVoverloading\fR) operations or functions for new data
type.
.SH EXAMPLE
.nf
//inline definition (see function)
function [x,y]=myfct(a,b)
x=a+b
y=a-b
endfunction

[x,y]=myfct(3,2)

//inline definition (see deff)
deff('[x,y]=myfct(a,b)',['x=a+b';
                         'y=a-b'])
// definition in an ascii file (see exec)
exec SCI/macros/elem/asin.sci;

// definition in an ascii file (see getf)
getf SCI/macros/elem/asin.sci;

.fi
.SH SEE ALSO
function, deff, getf, comp, lib, getd, genlib, exists, varargin, varargout


