.TH ltitr G "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
ltitr - discrete time response (state space)
.SH CALLING SEQUENCE
.nf
[X]=ltitr(A,B,U,[x0]) 
[xf,X]=ltitr(A,B,U,[x0])
.fi
.SH PARAMETERS
.TP 10
A,B 
: real  matrices of appropriate dimensions
.TP
U,X   
: real  matrices 
.TP
x0,xf  
: real vectors (default value=0 for \fVx0\fR))         
.SH DESCRIPTION
calculates the time response of the discrete time system
.nf
         x[t+1] = Ax[t] + Bu[t].
.fi
The inputs \fVui\fR's are the columns of the \fVU\fR matrix
.nf
        U=[u0,u1,...,un];
.fi
\fVx0\fR is the vector of initial state (default value : 0) ;
.LP
\fVX\fR is the matrix of outputs (same number of columns as \fVU\fR).
.LP
.nf
        X=[x0,x1,x2,...,xn] 
.fi    
\fVxf\fR is the vector of final state \fVxf=X[n+1]\fR
.SH EXAMPLE
.nf
A=eye(2,2);B=[1;1];
x0=[-1;-2];
u=[1,2,3,4,5];
x=ltitr(A,B,u,x0)
x1=A*x0+B*u(1)
x2=A*x1+B*u(2)
x3=A*x2+B*u(3) //....
.fi
.SH SEE ALSO 
rtitr, flts

