function ilib_gen_loader(name,table)
//------------------------------------
// generate a loader file for gateway
[mt,nt]=size(table);
if nt<>2 then error('second argument has wrong size ');end 
comp_target = getenv('COMPILER','NO');
if getenv('WIN32','NO')=='OK' then
  select comp_target
	case 'VC++'   then lib_suf='dll';
	case 'ABSOFT' then lib_suf='dll';
	else lib_suf='dll';
  end
else
  lib_suf=ilib_unix_soname();
end

fd=mopen('loader.sce',"w");
mfprintf(fd,"// generated by builder.sce: Please do not edit this file\n");
mfprintf(fd,"// ------------------------------------------------------\n");
mfprintf(fd,"%s_path=get_file_path(''loader.sce'');\n",name);
mfprintf(fd,"functions=[ ''%s'';\n",table(1,1));
for x=table(2:$,1)' ;mfprintf(fd,"            ''%s'';\n",x);end
mfprintf(fd,"];\n");
mfprintf(fd,"addinter(%s_path+''/%s.%s'',''%s'',functions);\n",name,name,lib_suf,name);
mclose(fd);




