/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPValidationModule.h

	Contains:	This module does a slew of validation on the RTSP server. The module
				should be paired with the client contained in this file, which gets
				built as a separate application.

	$Log: RTSPValidationModule.h,v $
	Revision 1.2  1999/02/19 23:08:42  ds
	Created
	

*/

#define _VALIDATION_CLIENT_ 0 	//there is a custom client for this module (it generates
								//very particular requests to the server)
								//Code for this client is contained herein
								//Enable flag if you want to build the client, disable
								//if you want to build the server module

#if !_VALIDATION_CLIENT_

#include "RTSPModule.h"

class RTSPValidationModule : public RTSPModule
{
	public:
		RTSPValidationModule() : RTSPModule() {}
		virtual ~RTSPValidationModule() {}
			
		virtual void FilterRequest(RTSPRequestInterface *request);
			
		virtual RTSPProtocol::RTSPStatusCode		 ProcessRequest(	RTSPRequestInterface *request);
													
	private:
	
		void SendLongResponse(RTSPRequestInterface* inRequest);
		
		//we need to keep state info between calls.
		static UInt32 sInvocationCount;
		static SInt32 sRequestInvocationCount;
		static OSMutex sMutex;//module is not re-entrant
	
};
#endif
