#ifndef __tracking_element__
#define __tracking_element__

#include <string.h>
#include <unistd.h>

#include "OSHeaders.h"
#include "plassert.h"

class TrackingElement {

	public:
		TrackingElement( pid_t pid, const char * name )
		{
			mName = new char[ strlen(name) + 1 ];
			
			ASSERT( mName );
			if( mName )
				strcpy( mName, name );
			
			mPID = pid;
			
		}		
		
		virtual ~TrackingElement() 
		{ 
			if ( mName )  
				delete [] mName;
		}
		
		char 	*mName;
		pid_t	mPID;

};

#endif