// File:	StepToGeom_MakeDirection.cxx
// Created:	Fri Jul  2 17:32:04 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>
// sln 22.10.2001. CTS23496: Direction is not created if it has null magnitude (StepToGeom_MakeDirection(...) function)

#include <StepToGeom_MakeDirection.ixx>
#include <StepGeom_Direction.hxx>
#include <StdFail_NotDone.hxx>

//=============================================================================
// Creation d' un Direction de Geom a partir d' un Direction de Step
//=============================================================================

StepToGeom_MakeDirection::StepToGeom_MakeDirection
  ( const Handle(StepGeom_Direction)& D)
{
  if (D->NbDirectionRatios() != 3 ) done = Standard_False;
  else
    {
      Standard_Real X = D->DirectionRatiosValue(1);
      Standard_Real Y = D->DirectionRatiosValue(2);
      Standard_Real Z = D->DirectionRatiosValue(3);
      // sln 22.10.2001. CTS23496: Direction is not created if it has null magnitude
      gp_XYZ aXYZ(X, Y, Z);
      
      Standard_Real res2 = gp::Resolution()*gp::Resolution();
      Standard_Real aMagnitude = aXYZ.SquareModulus();
      if(aMagnitude > res2) {
        theDirection = new Geom_Direction(X, Y, Z);
        done = Standard_True;
      }
      else
        done = Standard_False;
    }
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_Direction) &
      StepToGeom_MakeDirection::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theDirection;
}
