#include <PDataStd_Constraint.ixx>



PDataStd_Constraint::PDataStd_Constraint () { }

PDataStd_Constraint::PDataStd_Constraint(const Standard_Integer Type,
					 const Handle(PDF_HAttributeArray1)& Geometries,
					 const Handle(PDataStd_Real)& Value,
					 const Handle(PNaming_NamedShape)& Plane)

: myType (Type), myGeometries (Geometries), myValue (Value), myIsReversed(Standard_False),
  myIsInverted(Standard_False),
  myIsVerified(Standard_True),
  myPlane(Plane)
  {}

Handle(PDataStd_Real) PDataStd_Constraint::GetValue() const
{ return myValue; }

Standard_Integer PDataStd_Constraint::GetType() const
{ return myType; }

Handle(PDF_HAttributeArray1) PDataStd_Constraint::GetGeometries() const
{ return myGeometries; }

Handle(PNaming_NamedShape) PDataStd_Constraint::GetPlane() const 
{ return myPlane;}

void PDataStd_Constraint::SetPlane(const Handle(PNaming_NamedShape)& plane)
{ myPlane = plane;}

void PDataStd_Constraint::Set(const Handle(PDataStd_Real)& V) 
{ myValue = V; }

void PDataStd_Constraint::SetType(const Standard_Integer Type) 
{ myType = Type; }

void PDataStd_Constraint::SetGeometries(const Handle(PDF_HAttributeArray1)& Geometries) 
{ myGeometries = Geometries; }

//=======================================================================
//function : Verified
//purpose  : 
//=======================================================================
void PDataStd_Constraint::Verified(const Standard_Boolean status)
{
  myIsVerified = status;
}

//=======================================================================
//function : Verified
//purpose  : 
//=======================================================================
Standard_Boolean PDataStd_Constraint::Verified() const 
{
  return myIsVerified;
}

//=======================================================================
//function : Reversed
//purpose  : 
//=======================================================================
void PDataStd_Constraint::Reversed(const Standard_Boolean status)
{
  myIsReversed = status;
}

//=======================================================================
//function : Reversed
//purpose  : 
//=======================================================================
Standard_Boolean PDataStd_Constraint::Reversed() const 
{
  return myIsReversed;
}

//=======================================================================
//function : Inverted
//purpose  : 
//=======================================================================
void PDataStd_Constraint::Inverted(const Standard_Boolean status)
{
  myIsInverted = status;
}

//=======================================================================
//function : Inverted
//purpose  : 
//=======================================================================
Standard_Boolean PDataStd_Constraint::Inverted() const 
{
  return myIsInverted;
}
