/* MSRRE2.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#ifdef WNT
#include <MathBase.h>
#else 
#define  __MathBase_API
#endif
/* Subroutine */ __MathBase_API int mmsrre2_(tparam, nbrval, tablev, epsil, numint, itypen, 
	iercod)
doublereal *tparam;
integer *nbrval;
doublereal *tablev, *epsil;
integer *numint, *itypen, *iercod;
{
    /* System generated locals */
    doublereal d__1;

    /* Local variables */
    static integer ideb, ifin, imil, ibb;
    extern integer mnfndeb_();
    extern /* Subroutine */ int maermsg_(), mgenmsg_(), mgsomsg_();



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     -------- */

/*     Recherche l'intervalle correspondant a une valeur donnee dans */
/*     une suite croissante de reels double precision. */

/*     MOTS CLES : */
/*     --------- */
/*     TOUS,MATH_ACCES::TABLEAU&,POINT&,CORRESPONDANCE,&RANG */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */

/*     TPARAM  : Valeur a tester. */
/*     NBRVAL  : Taille de TABLEV */
/*     TABLEV  : Tableau de reels. */
/*     EPSIL   : Epsilon de precision */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */

/*     NUMINT  : Numero de l'intervalle (entre 1 et NBRVAL-1). */
/*     ITYPEN  : = 0 TPARAM est a l'interieur de l'intervalle NUMINT */
/*               = 1 : TPARAM correspond a la borne inferieure de */
/*                    l'intervalle fourni. */
/*               = 2 : TPARAM correspond a la borne superieure de */
/*                    l'intervalle fourni. */

/*     IERCOD : Code d'erreur */
/*                     = 0 : OK */
/*                     = 1 : TABLEV ne contient pas assez d' elements. */
/*                     = 2 : TPARAM hors des bornes de TABLEV. */

/*     COMMONS UTILISES : */
/*     ---------------- */

/*     REFERENCES APPELEES : */
/*     ------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     --------------------------------- */
/*     Il y a NBRVAL valeurs dans TABLEV soit NBRVAL-1 intervalles. */
/*     On fait une recherche de l' intervalle contenant TPARAM par */
/*     dichotomie. Complexite de l' algorithme : Log(n)/Log(2).(RBD). */


/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ---------------------------- */
/*     13-07-93 : MCL ; Version originale (a partir de MSRREI) */
/* > */
/* ***********************************************************************
 */


/* Initialisations */

    /* Parameter adjustments */
    --tablev;

    /* Function Body */
    ibb = mnfndeb_();
    if (ibb >= 6) {
	mgenmsg_("MMSRRE2", 7L);
    }

    *iercod = 0;
    *numint = 0;
    *itypen = 0;
    ideb = 1;
    ifin = *nbrval;

/* TABLEV doit contenir au moins deux valeurs */

    if (*nbrval < 2) {
	*iercod = 1;
	goto L9999;
    }

/* TPARAM doit etre entre les bornes extremes de TABLEV. */

    if (*tparam < tablev[1] || *tparam > tablev[*nbrval]) {
	*iercod = 2;
	goto L9999;
    }

/* ----------------------- RECHERCHE DE L'INTERVALLE -------------------- 
*/

L1000:

/* Test de fin de boucle (on a trouve). */

    if (ideb + 1 == ifin) {
	*numint = ideb;
	goto L2000;
    }

/* Recherche par dichotomie sur les valeurs croissantes de TABLEV. */

    imil = (ideb + ifin) / 2;
    if (*tparam >= tablev[ideb] && *tparam <= tablev[imil]) {
	ifin = imil;
    } else {
	ideb = imil;
    }

    goto L1000;

/* -------------- TEST POUR VOIR SI TPARAM N'EST PAS UNE VALEUR --------- 
*/
/* ------------------------ DE TABLEV A EPSIL PRES ---------------------- 
*/

L2000:
    if ((d__1 = *tparam - tablev[ideb], abs(d__1)) < *epsil) {
	*itypen = 1;
	goto L9999;
    }
    if ((d__1 = *tparam - tablev[ifin], abs(d__1)) < *epsil) {
	*itypen = 2;
	goto L9999;
    }

/* --------------------------- THE END ---------------------------------- 
*/

L9999:
    if (*iercod > 0) {
	maermsg_("MMSRRE2", iercod, 7L);
    }
    if (ibb >= 6) {
	mgsomsg_("MMSRRE2", 7L);
    }
 return 0 ;
} /* mmsrre2_ */

