// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _WOKernel_Workshop_HeaderFile
#define _WOKernel_Workshop_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_WOKernel_Workshop_HeaderFile
#include <Handle_WOKernel_Workshop.hxx>
#endif

#ifndef _Handle_TColStd_HSequenceOfHAsciiString_HeaderFile
#include <Handle_TColStd_HSequenceOfHAsciiString.hxx>
#endif
#ifndef _Handle_WOKernel_HSequenceOfDBMSID_HeaderFile
#include <Handle_WOKernel_HSequenceOfDBMSID.hxx>
#endif
#ifndef _WOKernel_Entity_HeaderFile
#include <WOKernel_Entity.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Handle_WOKernel_Factory_HeaderFile
#include <Handle_WOKernel_Factory.hxx>
#endif
#ifndef _Handle_WOKUtils_HSequenceOfParamItem_HeaderFile
#include <Handle_WOKUtils_HSequenceOfParamItem.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_WOKernel_HSequenceOfStationID_HeaderFile
#include <Handle_WOKernel_HSequenceOfStationID.hxx>
#endif
#ifndef _Handle_WOKernel_Workbench_HeaderFile
#include <Handle_WOKernel_Workbench.hxx>
#endif
class TColStd_HSequenceOfHAsciiString;
class WOKernel_HSequenceOfDBMSID;
class Standard_ProgramError;
class TCollection_HAsciiString;
class WOKernel_Factory;
class WOKUtils_HSequenceOfParamItem;
class WOKernel_HSequenceOfStationID;
class WOKernel_Workbench;


//! a workshop is a tree of workbench <br>
//!          It is used to work under a particular Parcel config <br>
//!          for a particuliar job <br>
//!          A worshop implies a root workbench in it <br>
class WOKernel_Workshop : public WOKernel_Entity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT WOKernel_Workshop(const Handle(TCollection_HAsciiString)& aname,const Handle(WOKernel_Factory)& anesting);

//! constructs Sequence of Parameters Needed by Entity <br>
//!          to be built. <br>
//!          Checks their consistancy <br>
Standard_EXPORT virtual  Handle_WOKUtils_HSequenceOfParamItem BuildParameters(const Handle(WOKUtils_HSequenceOfParamItem)& someparams,const Standard_Boolean usedefaults) ;


Standard_EXPORT virtual  Handle_TCollection_HAsciiString EntityCode() const;

//! Fills Workbench List <br>
Standard_EXPORT   void GetWorkbenches() ;

//! Fills Parcel List <br>
Standard_EXPORT   void GetParcelsInUse() ;


Standard_EXPORT virtual  void Open() ;


Standard_EXPORT virtual  void Close() ;


Standard_EXPORT   Handle_TColStd_HSequenceOfHAsciiString Workbenches() const;


Standard_EXPORT   Handle_TColStd_HSequenceOfHAsciiString ParcelsInUse() const;

//! Retourne les Stations Supportees par l'ilot <br>
Standard_EXPORT   Handle_WOKernel_HSequenceOfStationID SupportedStations() const;

//! Change la liste des Stations supportees <br>
Standard_EXPORT   void SetSupportedStations(const Handle(WOKernel_HSequenceOfStationID)& stations) ;

//! updates Workbench List <br>
Standard_EXPORT   void DumpWorkbenchList() const;

//! Adds a wb to the workshop <br>
Standard_EXPORT   void AddWorkbench(const Handle(WOKernel_Workbench)& aworkbench) ;

//! Removes a wb to the workshop <br>
Standard_EXPORT   void RemoveWorkbench(const Handle(WOKernel_Workbench)& aworkbench) ;
//Standard_EXPORT ~WOKernel_Workshop();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


Standard_EXPORT virtual  void GetParameters() ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TColStd_HSequenceOfHAsciiString myworkbenches;
Handle_TColStd_HSequenceOfHAsciiString myparcelsinuse;
Handle_TColStd_HSequenceOfHAsciiString mystations;
Handle_WOKernel_HSequenceOfDBMSID mydbms;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
