// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _V3d_HeaderFile
#define _V3d_HeaderFile

#ifndef _V3d_TypeOfOrientation_HeaderFile
#include <V3d_TypeOfOrientation.hxx>
#endif
#ifndef _Handle_Graphic3d_Group_HeaderFile
#include <Handle_Graphic3d_Group.hxx>
#endif
#ifndef _V3d_Coordinate_HeaderFile
#include <V3d_Coordinate.hxx>
#endif
#ifndef _V3d_Parameter_HeaderFile
#include <V3d_Parameter.hxx>
#endif
#ifndef _Quantity_PlaneAngle_HeaderFile
#include <Quantity_PlaneAngle.hxx>
#endif
#ifndef _Handle_V3d_View_HeaderFile
#include <Handle_V3d_View.hxx>
#endif
#ifndef _Handle_V3d_Viewer_HeaderFile
#include <Handle_V3d_Viewer.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
class Graphic3d_Vector;
class Graphic3d_Group;
class V3d_View;
class V3d_Viewer;
class V3d_Viewer;
class V3d_View;
class V3d_OrthographicView;
class V3d_PerspectiveView;
class V3d_Light;
class V3d_AmbientLight;
class V3d_PositionLight;
class V3d_PositionalLight;
class V3d_DirectionalLight;
class V3d_SpotLight;
class V3d_Camera;
class V3d_Plane;
class V3d_ListOfTransient;
class V3d_RectangularGrid;
class V3d_CircularGrid;
class V3d_ColorScale;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This package contains the set of commands and services <br>
//!          of the 3D Viewer. It provides a set of high level commands <br>
//!          to control the views and viewing modes. This package is <br>
//!          complementary to the Visual3D graphic package. <br>
//!    Warning <br>
//! The CSF_WALKTHROUGH variable enables you to <br>
//! manage the perspective of the view in the viewer by <br>
//! defining setenv CSF_WALKTHROUGH "Yes". <br>
//! If you use the syntax unsetenv <br>
//! CSF_WALKTHROUGH, you undefine the variable <br>
//! (you make sure that the variable is deactivated). In <br>
//! this case, the eye is located outside the 3D bounding <br>
//! box of the view. This is the default behavior for <br>
//! managing the view perspective. <br>
class V3d  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Determines the orientation vector corresponding <br>
//!          to the predefined orientation type. <br>
Standard_EXPORT static  Graphic3d_Vector GetProjAxis(const V3d_TypeOfOrientation Orientation) ;

//! Compute the graphic structure of arrow. <br>
//!          X0,Y0,Z0 : coordinate of the arrow. <br>
//!          DX,DY,DZ : Direction of the arrow. <br>
//!          Alpha    : Angle of arrow. <br>
//!          Lng      : Length of arrow. <br>
Standard_EXPORT static  void ArrowOfRadius(const Handle(Graphic3d_Group)& garrow,const V3d_Coordinate X0,const V3d_Coordinate Y0,const V3d_Coordinate Z0,const V3d_Parameter DX,const V3d_Parameter DY,const V3d_Parameter DZ,const Quantity_PlaneAngle Alpha,const V3d_Parameter Lng) ;

//! Compute the graphic structure of circle. <br>
//!          X0,Y0,Z0 : Center of circle. <br>
//!          VX,VY,VZ : Axis of circle. <br>
//!          Radius   : Radius of circle. <br>
Standard_EXPORT static  void CircleInPlane(const Handle(Graphic3d_Group)& gcircle,const V3d_Coordinate X0,const V3d_Coordinate Y0,const V3d_Coordinate Z0,const V3d_Parameter VX,const V3d_Parameter VY,const V3d_Parameter VZ,const V3d_Parameter Radius) ;


Standard_EXPORT static  void SwitchViewsinWindow(const Handle(V3d_View)& aPreviousView,const Handle(V3d_View)& aNextView) ;

//! test. <br>
Standard_EXPORT static  void DrawSphere(const Handle(V3d_Viewer)& aViewer,const Quantity_Length aRadius = 1000) ;

//! test. <br>
Standard_EXPORT static  void PickGrid(const Handle(V3d_Viewer)& aViewer,const Quantity_Length aRadius = 1000) ;

//! test. <br>
Standard_EXPORT static  void SetPlane(const Handle(V3d_Viewer)& aViewer,const Quantity_Length x1,const Quantity_Length y1,const Quantity_Length z1,const Quantity_Length x2,const Quantity_Length y2,const Quantity_Length z2) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class V3d_Viewer;
friend class V3d_View;
friend class V3d_OrthographicView;
friend class V3d_PerspectiveView;
friend class V3d_Light;
friend class V3d_AmbientLight;
friend class V3d_PositionLight;
friend class V3d_PositionalLight;
friend class V3d_DirectionalLight;
friend class V3d_SpotLight;
friend class V3d_Camera;
friend class V3d_Plane;
friend class V3d_ListOfTransient;
friend class V3d_RectangularGrid;
friend class V3d_CircularGrid;
friend class V3d_ColorScale;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
