// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeProcessAPI_ApplySequence_HeaderFile
#define _ShapeProcessAPI_ApplySequence_HeaderFile

#ifndef _Handle_ShapeProcess_ShapeContext_HeaderFile
#include <Handle_ShapeProcess_ShapeContext.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeShape_HeaderFile
#include <TopTools_DataMapOfShapeShape.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
#ifndef _Handle_Message_Printer_HeaderFile
#include <Handle_Message_Printer.hxx>
#endif
class ShapeProcess_ShapeContext;
class TopoDS_Shape;
class TopTools_DataMapOfShapeShape;
class Message_Printer;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Applies one of the sequence read from resource file. <br>
class ShapeProcessAPI_ApplySequence  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an object and loads resource file and sequence of <br>
//!          operators given by their names. <br>
Standard_EXPORT ShapeProcessAPI_ApplySequence(const Standard_CString rscName,const Standard_CString seqName = "");

//! Returns object for managing resource file and sequence of <br>
//!          operators. <br>
Standard_EXPORT   Handle_ShapeProcess_ShapeContext& Context() ;

//! Performs sequence of operators stored in myRsc. <br>
//!          If <fillmap> is True adds history "shape-shape" into myMap <br>
//!          for shape and its subshapes until level <until> (included). <br>
//!          If <until> is TopAbs_SHAPE,  all the subshapes are considered. <br>
Standard_EXPORT   TopoDS_Shape PrepareShape(const TopoDS_Shape& shape,const Standard_Boolean fillmap = Standard_False,const TopAbs_ShapeEnum until = TopAbs_SHAPE) ;

//! Clears myMap with accumulated history. <br>
Standard_EXPORT   void ClearMap() ;

//! Returns myMap with accumulated history. <br>
Standard_EXPORT  const TopTools_DataMapOfShapeShape& Map() const;

//! Prints result of preparation onto the Printer. <br>
//!          Note that results can be accumulated from previous preparations <br>
//!          it method ClearMap was not called before PrepareShape. <br>
Standard_EXPORT   void PrintPreparationResult(const Handle(Message_Printer)& printer) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_ShapeProcess_ShapeContext myContext;
TopTools_DataMapOfShapeShape myMap;
TCollection_AsciiString mySeq;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
