#ifndef _InterfaceGraphic_PrimitiveArray_header_file_
#define _InterfaceGraphic_PrimitiveArray_header_file_

/*
   FILE: InterfaceGraphic_PrimitiveArray.hxx
   
   Created 16/06/2000 : ATS,SPK : G005

   This file contains definitios of internal structures for 
   PARRAY and DARRAY primitives, used in OpenGl package for presentation

*/

#include <InterfaceGraphic_telem.h>
#include <InterfaceGraphic_degeneration.h>

#define MVERTICE 1
#define MVNORMAL 2
#define MVCOLOR 4
#define MVTEXEL 8

#define xIARRAY 1

typedef enum {
  TelUnknownArrayType,
  TelPointsArrayType,
  TelPolylinesArrayType,
  TelSegmentsArrayType,
  TelPolygonsArrayType,
  TelTrianglesArrayType,
  TelQuadranglesArrayType,
  TelTriangleStripsArrayType,
  TelQuadrangleStripsArrayType,
  TelTriangleFansArrayType
} TelPrimitivesArrayType;

#ifdef IARRAY
typedef struct {
  Tfloat x,y,z;
} IV3F;

typedef struct {
  Tfloat r,g,b,x,y,z;
} IC3FV3F;

typedef struct {
  Tfloat r,g,b,a,nx,ny,nz,x,y,z;
} IC4FN3FV3F;

typedef struct {
  Tfloat nx,ny,nz,x,y,z;
} IN3FV3F;

typedef struct {
  Tfloat tx,ty,x,y,z;
} IT2FV3F;

typedef struct {
  Tfloat tx,ty,nx,ny,nz,x,y,z;
} IT2FN3FV3F;

typedef struct {
  Tfloat tx,ty,r,g,b,x,y,z;
} IT2FC3FV3F;

typedef struct {
  Tfloat tx,ty,r,g,b,a,nx,ny,nz,x,y,z;
} IT2FC4FN3FV3F;

typedef union {
  void *any;
  IV3F *v3f;
  IC3FV3F *c3fv3f;
  IC4FN3FV3F *c4fn3fv3f;
  IN3FV3F *n3fv3f;
  IT2FV3F *t2fv3f;
  IT2FN3FV3F *t2fn3fv3f;
  IT2FC3FV3F *t2fc3fv3f;
  IT2FC4FN3FV3F *t2fc4fn3fv3f;
} IVERTEX;
#endif

typedef struct {
  TelPrimitivesArrayType type;	      	/* Array type */
  Tint	       format;			/* Array datas format */
  Tint        num_vertexs;   		/* Number of vertexs */
  Tint        num_bounds;    		/* Number of bounds */
  Tint        num_edges;     		/* Number of edges */
  Tint        *bounds;       		/* Bounds array */
  Tint        *edges;        		/* Edges array vertex index */
  tel_colour  fcolours;       		/* Facet colour values */
  tel_point   vertices;       		/* Vertices */
  tel_colour  vcolours;       		/* Vertex colour values */
  tel_point   vnormals;       		/* Vertex normals */
  tel_texture_coord vtexels; 		/* Texture Coordinates */
  Tchar       *edge_vis;     		/* Edge visibility flag*/
  Tchar       *keys;     		/* Vertex keys*/
#ifdef IARRAY
  IVERTEX     ivertex;         	/* Interleaved vertex array */
#endif
} CALL_DEF_PARRAY;

#endif /* _InterfaceGraphic_PrimitiveArray_header_file_ */
