// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESSolid_Torus_HeaderFile
#define _IGESSolid_Torus_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESSolid_Torus_HeaderFile
#include <Handle_IGESSolid_Torus.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_XYZ_HeaderFile
#include <gp_XYZ.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
class gp_XYZ;
class gp_Pnt;
class gp_Dir;


//! defines Torus, Type <160> Form Number <0> <br>
//!          in package IGESSolid <br>
//!          A Torus is a solid formed by revolving a circular disc <br>
//!          about a specified coplanar axis. <br>
class IGESSolid_Torus : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESSolid_Torus();

//! This method is used to set the fields of the class Torus <br>
//!       - R1     : distance from center of torus to center <br>
//!                  of circular disc to be revolved <br>
//!       - R2     : radius of circular disc <br>
//!       - aPoint : center point coordinates (default (0,0,0)) <br>
//!       - anAxis : unit vector in axis direction (default (0,0,1)) <br>
Standard_EXPORT   void Init(const Standard_Real R1,const Standard_Real R2,const gp_XYZ& aPoint,const gp_XYZ& anAxisdir) ;

//! returns the distance from the center of torus to the center of <br>
//! the disc to be revolved <br>
Standard_EXPORT   Standard_Real MajorRadius() const;

//! returns the radius of the disc to be revolved <br>
Standard_EXPORT   Standard_Real DiscRadius() const;

//! returns the center of torus <br>
Standard_EXPORT   gp_Pnt AxisPoint() const;

//! returns the center of torus after applying TransformationMatrix <br>
Standard_EXPORT   gp_Pnt TransformedAxisPoint() const;

//! returns direction of the axis <br>
Standard_EXPORT   gp_Dir Axis() const;

//! returns direction of the axis after applying TransformationMatrix <br>
Standard_EXPORT   gp_Dir TransformedAxis() const;
//Standard_EXPORT ~IGESSolid_Torus();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real theR1;
Standard_Real theR2;
gp_XYZ thePoint;
gp_XYZ theAxis;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
