// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESGeom_ConicArc_HeaderFile
#define _IGESGeom_ConicArc_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESGeom_ConicArc_HeaderFile
#include <Handle_IGESGeom_ConicArc.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_XY_HeaderFile
#include <gp_XY.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class gp_XY;
class gp_Pnt2d;
class gp_Pnt;
class gp_Dir;


//! defines IGESConicArc, Type <104> Form <0-3>  in package IGESGeom <br>
//!          A conic arc is a bounded connected portion of a parent <br>
//!          conic curve which consists of more than one point. The <br>
//!          parent conic curve is either an ellipse, a parabola, or <br>
//!          a hyperbola. The definition space coordinate system is <br>
//!          always chosen so that the conic arc lies in a plane either <br>
//!          coincident with or parallel to XT, YT plane. Within such <br>
//!          a plane a conic is defined by the six coefficients in the <br>
//!          following equation. <br>
//!          A*XT^2 + B*XT*YT + C*YT^2 + D*XT + E*YT + F = 0 <br>
class IGESGeom_ConicArc : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESGeom_ConicArc();

//! This method is used to set the fields of the class <br>
//!           ConicalArc <br>
//!       - A, B, C, D, E, F : Coefficients of the equation <br>
//!                            defining conic arc <br>
//!       - ZT               : Parallel ZT displacement of the arc <br>
//!                            from XT, YT plane. <br>
//!       - aStart           : Starting point of the conic arc <br>
//!       - anEnd            : End point of the conic arc <br>
Standard_EXPORT   void Init(const Standard_Real A,const Standard_Real B,const Standard_Real C,const Standard_Real D,const Standard_Real E,const Standard_Real F,const Standard_Real ZT,const gp_XY& aStart,const gp_XY& anEnd) ;

//! sets the Form Number equal to ComputedFormNumber, <br>
//!           returns True if changed <br>
Standard_EXPORT   Standard_Boolean OwnCorrect() ;

//! Computes the Form Number according to the equation <br>
//!           1 for Ellipse, 2 for Hyperbola, 3 for Parabola <br>
Standard_EXPORT   Standard_Integer ComputedFormNumber() const;


Standard_EXPORT   void Equation(Standard_Real& A,Standard_Real& B,Standard_Real& C,Standard_Real& D,Standard_Real& E,Standard_Real& F) const;

//! returns the Z displacement of the arc from XT, YT plane <br>
Standard_EXPORT   Standard_Real ZPlane() const;

//! returns the starting point of the arc <br>
Standard_EXPORT   gp_Pnt2d StartPoint() const;

//! returns the starting point of the arc after applying <br>
//! Transf. Matrix <br>
Standard_EXPORT   gp_Pnt TransformedStartPoint() const;

//! returns the end point of the arc <br>
Standard_EXPORT   gp_Pnt2d EndPoint() const;

//! returns the end point of the arc after applying <br>
//! Transf. Matrix <br>
Standard_EXPORT   gp_Pnt TransformedEndPoint() const;

//! returns True if parent conic curve is an ellipse <br>
Standard_EXPORT   Standard_Boolean IsFromEllipse() const;

//! returns True if parent conic curve is a parabola <br>
Standard_EXPORT   Standard_Boolean IsFromParabola() const;

//! returns True if parent conic curve is a hyperbola <br>
Standard_EXPORT   Standard_Boolean IsFromHyperbola() const;

//! returns True if StartPoint = EndPoint <br>
Standard_EXPORT   Standard_Boolean IsClosed() const;

//! Z-Axis of conic (i.e. [0,0,1]) <br>
Standard_EXPORT   gp_Dir Axis() const;

//! Z-Axis after applying Trans. Matrix <br>
Standard_EXPORT   gp_Dir TransformedAxis() const;

//! Returns a Definition computed from equation, easier to use <br>
//!           <Center> : the center of the the conic (meaningless for <br>
//!                      a parabola) (defined with Z displacement) <br>
//!           <MainAxis> : the Main Axis of the conic (for a Circle, <br>
//!                        arbitrary the X Axis) <br>
//!           <Rmin,Rmax> : Minor and Major Radii of the conic <br>
//!                         For a Circle, Rmin = Rmax, <br>
//!                         For a Parabola, Rmin = Rmax = the Focal <br>
//!  Warning : the basic definition (by equation) is not very stable, <br>
//!           limit cases may be approximative <br>
Standard_EXPORT   void Definition(gp_Pnt& Center,gp_Dir& MainAxis,Standard_Real& rmin,Standard_Real& rmax) const;

//! Same as Definition, but the Location is applied on the <br>
//!           Center and the MainAxis <br>
Standard_EXPORT   void TransformedDefinition(gp_Pnt& Center,gp_Dir& MainAxis,Standard_Real& rmin,Standard_Real& rmax) const;

//! Computes and returns the coordinates of the definition of <br>
//!           a comic from its equation. Used by Definition & <br>
//!           TransformedDefinition, or may be called directly if needed <br>
Standard_EXPORT   void ComputedDefinition(Standard_Real& Xcen,Standard_Real& Ycen,Standard_Real& Xax,Standard_Real& Yax,Standard_Real& Rmin,Standard_Real& Rmax) const;
//Standard_EXPORT ~IGESGeom_ConicArc();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real theA;
Standard_Real theB;
Standard_Real theC;
Standard_Real theD;
Standard_Real theE;
Standard_Real theF;
Standard_Real theZT;
gp_XY theStart;
gp_XY theEnd;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
