// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom_CartesianPoint_HeaderFile
#define _Geom_CartesianPoint_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Geom_CartesianPoint_HeaderFile
#include <Handle_Geom_CartesianPoint.hxx>
#endif

#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Geom_Point_HeaderFile
#include <Geom_Point.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Geom_Geometry_HeaderFile
#include <Handle_Geom_Geometry.hxx>
#endif
class gp_Pnt;
class gp_Trsf;
class Geom_Geometry;


//! Describes a point in 3D space. A <br>
//! Geom_CartesianPoint is defined by a gp_Pnt point, <br>
//! with its three Cartesian coordinates X, Y and Z. <br>
class Geom_CartesianPoint : public Geom_Point {

public:
 // Methods PUBLIC
 // 

//! Returns a transient copy of P. <br>
Standard_EXPORT Geom_CartesianPoint(const gp_Pnt& P);

//! Constructs a point defined by its three Cartesian coordinates X, Y and Z. <br>
Standard_EXPORT Geom_CartesianPoint(const Standard_Real X,const Standard_Real Y,const Standard_Real Z);

//! Assigns the coordinates X, Y and Z to this point. <br>
Standard_EXPORT   void SetCoord(const Standard_Real X,const Standard_Real Y,const Standard_Real Z) ;

//! Set <me> to P.X(), P.Y(), P.Z() coordinates. <br>
Standard_EXPORT   void SetPnt(const gp_Pnt& P) ;

//! Changes the X coordinate of me. <br>
Standard_EXPORT   void SetX(const Standard_Real X) ;

//! Changes the Y coordinate of me. <br>
Standard_EXPORT   void SetY(const Standard_Real Y) ;

//! Changes the Z coordinate of me. <br>
Standard_EXPORT   void SetZ(const Standard_Real Z) ;

//! Returns the coordinates of <me>. <br>
Standard_EXPORT   void Coord(Standard_Real& X,Standard_Real& Y,Standard_Real& Z) const;


//!  Returns a non transient cartesian point with <br>
//!  the same coordinates as <me>. <br>
Standard_EXPORT   gp_Pnt Pnt() const;

//! Returns the X coordinate of <me>. <br>
Standard_EXPORT   Standard_Real X() const;

//! Returns the Y coordinate of <me>. <br>
Standard_EXPORT   Standard_Real Y() const;

//! Returns the Z coordinate of <me>. <br>
Standard_EXPORT   Standard_Real Z() const;

//! Applies the transformation T to this point. <br>
Standard_EXPORT   void Transform(const gp_Trsf& T) ;

//!  Creates a new object which is a copy of this point. <br>
Standard_EXPORT   Handle_Geom_Geometry Copy() const;
//Standard_EXPORT ~Geom_CartesianPoint();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Pnt gpPnt;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
