// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GeomPlate_BuildAveragePlane_HeaderFile
#define _GeomPlate_BuildAveragePlane_HeaderFile

#ifndef _Handle_TColgp_HArray1OfPnt_HeaderFile
#include <Handle_TColgp_HArray1OfPnt.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Geom_Plane_HeaderFile
#include <Handle_Geom_Plane.hxx>
#endif
#ifndef _Handle_Geom_Line_HeaderFile
#include <Handle_Geom_Line.hxx>
#endif
#ifndef _gp_Vec_HeaderFile
#include <gp_Vec.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TColgp_HArray1OfPnt;
class Geom_Plane;
class Geom_Line;
class Standard_NoSuchObject;
class TColgp_SequenceOfVec;
class gp_Vec;
class GeomPlate_SequenceOfAij;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class computes an average inertial plane with an <br>
//!          array of points. <br>
class GeomPlate_BuildAveragePlane  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Tol is a  Tolerance to make the difference between <br>
//!           the result plane and the result line. <br>
//! if POption = 1 : automatical parametrisation <br>
//! if POption = 2 : parametrisation by eigen vectors <br>
//! if NOption = 1 : the average plane is the inertial plane. <br>
//! if NOption = 2 : the average plane is the plane of max. flux. <br>
Standard_EXPORT GeomPlate_BuildAveragePlane(const Handle(TColgp_HArray1OfPnt)& Pts,const Standard_Integer NbBoundPoints,const Standard_Real Tol,const Standard_Integer POption,const Standard_Integer NOption);

//! Creates the plane from the "best vector" <br>
Standard_EXPORT GeomPlate_BuildAveragePlane(const TColgp_SequenceOfVec& Normals,const Handle(TColgp_HArray1OfPnt)& Pts);


//! Return the average Plane. <br>
Standard_EXPORT   Handle_Geom_Plane Plane() const;


//! Return a Line when 2 eigenvalues are null. <br>
Standard_EXPORT   Handle_Geom_Line Line() const;

//! return OK if is a plane. <br>
Standard_EXPORT   Standard_Boolean IsPlane() const;

//! return OK if is a line. <br>
Standard_EXPORT   Standard_Boolean IsLine() const;

//! computes the   minimal box  to include  all normal <br>
//!          projection points of the initial array  on the plane. <br>
Standard_EXPORT   void MinMaxBox(Standard_Real& Umin,Standard_Real& Umax,Standard_Real& Vmin,Standard_Real& Vmax) const;


Standard_EXPORT static  Standard_Boolean HalfSpace(const TColgp_SequenceOfVec& NewNormals,TColgp_SequenceOfVec& Normals,GeomPlate_SequenceOfAij& Bset,const Standard_Real LinTol,const Standard_Real AngTol) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Computes a base of the average plane defined by (myG,N) <br>
//! using eigen vectors <br>
Standard_EXPORT   void BasePlan(const gp_Vec& N) ;

//! Defines the average plane. <br>
//! if NOption = 1 : the average plane is the inertial plane. <br>
//! if NOption = 2 : the average plane is the plane of max. flux. <br>
Standard_EXPORT   gp_Vec DefPlan(const Standard_Integer NOption) ;


 // Fields PRIVATE
 //
Handle_TColgp_HArray1OfPnt myPts;
Standard_Real myUmax;
Standard_Real myVmax;
Standard_Real myVmin;
Standard_Real myUmin;
Handle_Geom_Plane myPlane;
Standard_Real myTol;
Handle_Geom_Line myLine;
gp_Vec myOX;
gp_Vec myOY;
gp_Pnt myG;
Standard_Integer myNbBoundPoints;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
