#ifndef _StdLSchema_PDF_Data_HeaderFile_
#include <StdLSchema_PDF_Data.hxx>
#endif
#ifndef _PDF_Data_HeaderFile_
#include <PDF_Data.hxx>
#endif
#include <StdLSchema_PDF_Data.ixx>
#ifndef _Storage_Schema_HeaderFile_
#include <Storage_Schema.hxx>
#endif
#ifndef _Storage_stCONSTclCOM_HeaderFile_
#include <Storage_stCONSTclCOM.hxx>
#endif

Handle_Standard_Type& StdLSchema_PDF_Data_Type_()
{

  static Handle_Standard_Type tSchema = STANDARD_TYPE(StdLSchema_PDF_Data); 
  static Handle_Standard_Type bSchema = STANDARD_TYPE(Storage_CallBack);

  static Handle_Standard_Transient _Ancestors[]= {tSchema,bSchema,NULL};
  static Handle_Standard_Type _aType = new Standard_Type("StdLSchema_PDF_Data",
			                                 sizeof(StdLSchema_PDF_Data),
			                                 1,
			                                 (Standard_Address)_Ancestors,
			                                 (Standard_Address)NULL);

  return _aType;
}

const Handle(StdLSchema_PDF_Data) Handle(StdLSchema_PDF_Data)::DownCast(const Handle(Storage_CallBack)& AnObject) {
  Handle(StdLSchema_PDF_Data) _anOtherObject;

  if (!AnObject.IsNull()) {
     if (AnObject->IsKind(STANDARD_TYPE(StdLSchema_PDF_Data))) {
       _anOtherObject = Handle(StdLSchema_PDF_Data)((Handle(StdLSchema_PDF_Data)&)AnObject);
     }
  }

  return _anOtherObject ;
}

Standard_Boolean StdLSchema_PDF_Data::IsKind(const Handle(Standard_Type)& AType) const { 
  return (STANDARD_TYPE(StdLSchema_PDF_Data) == AType || Storage_CallBack::IsKind(AType)); 
}

const Handle(Standard_Type)& StdLSchema_PDF_Data::DynamicType() const { 
  return STANDARD_TYPE(StdLSchema_PDF_Data) ; 
}
Handle(Standard_Persistent) StdLSchema_PDF_Data::New() const
{
 return new PDF_Data(Storage_stCONSTclCOM());
}

void StdLSchema_PDF_Data::SAdd(const Handle(PDF_Data)& p, const Handle(Storage_Schema)& theSchema)
{
  if (!p.IsNull()) {
    if (theSchema->AddPersistent(p,"PDF_Data")) {
         theSchema->PersistentToAdd(p->_CSFDB_GetPDF_DatamyLabels());
   theSchema->PersistentToAdd(p->_CSFDB_GetPDF_DatamyAttributes());

    }
  }
}

void StdLSchema_PDF_Data::Add(const Handle(Standard_Persistent)& p, const Handle(Storage_Schema)& theSchema) const {
  StdLSchema_PDF_Data::SAdd((Handle(PDF_Data)&)p,theSchema);
}

void StdLSchema_PDF_Data::SWrite(const Handle(Standard_Persistent)& p, Storage_BaseDriver& f, const Handle(Storage_Schema)& theSchema)
{ 
  if (!p.IsNull()) {
    Handle(PDF_Data) &pp = (Handle(PDF_Data)&)p;
    theSchema->WritePersistentObjectHeader(p,f);
    
    f.BeginWritePersistentObjectData();
  f.PutInteger(pp->_CSFDB_GetPDF_DatamyVersion());
  theSchema->WritePersistentReference(pp->_CSFDB_GetPDF_DatamyLabels(),f);
  theSchema->WritePersistentReference(pp->_CSFDB_GetPDF_DatamyAttributes(),f);

    f.EndWritePersistentObjectData();
  }
}

void StdLSchema_PDF_Data::Write(const Handle(Standard_Persistent)& p, Storage_BaseDriver& f, const Handle(Storage_Schema)& theSchema) const
{ 
 StdLSchema_PDF_Data::SWrite(p,f,theSchema);
}
void StdLSchema_PDF_Data::SRead(const Handle(Standard_Persistent)& p, Storage_BaseDriver& f, const Handle(Storage_Schema)& theSchema)
{ 
  if (!p.IsNull()) {
    Handle(PDF_Data) &pp = (Handle(PDF_Data)&)p;

    theSchema->ReadPersistentObjectHeader(f);
    f.BeginReadPersistentObjectData();


    Standard_Integer PDF_DatamyVersion;
    f.GetInteger(PDF_DatamyVersion);
    pp->_CSFDB_SetPDF_DatamyVersion(PDF_DatamyVersion);

    Handle(PColStd_HArray1OfInteger) PDF_DatamyLabels;

    theSchema->ReadPersistentReference(PDF_DatamyLabels,f);
    pp->_CSFDB_SetPDF_DatamyLabels(PDF_DatamyLabels);

    Handle(PDF_HAttributeArray1) PDF_DatamyAttributes;

    theSchema->ReadPersistentReference(PDF_DatamyAttributes,f);
    pp->_CSFDB_SetPDF_DatamyAttributes(PDF_DatamyAttributes);

    f.EndReadPersistentObjectData();
  }
}

void StdLSchema_PDF_Data::Read(const Handle(Standard_Persistent)& p, Storage_BaseDriver& f, const Handle(Storage_Schema)& theSchema) const
{ 
 StdLSchema_PDF_Data::SRead(p,f,theSchema);
}
