/*
 *   dspglist.h -- low level linked list routine prototypes 
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */

/**************************************************************************
*
*  FUNCTION PROTOTYPES.   See below for descriptions of each procedure
*
**************************************************************************/

RC     CDLLInsTail (VOID *,  VOID **, VOID **, VOID **, VOID **, VOID **);
//RC     CDLLInsHead (VOID *,  VOID **, VOID **, VOID **, VOID **, VOID **);
PVOID  CDLLDelNode (VOID **, VOID **, VOID **, VOID **, VOID **);
RC     CLLInsTail  (VOID *,  VOID **, VOID **, VOID **);
RC     CLLInsHead  (VOID *,  VOID **, VOID **, VOID **);
PVOID  CLLDelNode  (VOID **, VOID **, VOID *,  VOID **);
//PVOID  CLLDelHead  (VOID **, VOID **, VOID **);


/**************************************************************************
**   CDLLInsTail                                                         **
***************************************************************************
*
* ARGUMENTS: See figure below
*
*     pNode       -  ptr to PREVIOUSLY ALLOCATED STRUCTURE
*     ppNodeNext  -  ptr to Next pointer inside new Node
*     ppNodePrev  -  ptr to Prev pointer inside new Node
*     ppTailNext  -  ptr to Next pointer inside last Node of existing list
*     ppHeadPrev  -  ptr to Prev pointer inside first Node of existing list
*     ppTail      -  ptr to Tail pointer of list
*
* RETURN:
*     0           - OK
*
* DESCRIPTION: Insert a node at the tail of a circular doubly linked list
*
*
*    INSERT INTO A NON-EMPTY LIST                 INSERT INTO AN EMPTY LIST
*               Ŀ                                 Ŀ
*         ppTail                                   ppTail pNode
*                 Ŀ             Ŀ              Ŀ  Ŀ
*                >         pNode              >    
*                                                    
*                     +------------+                     |    
*  v-------v--v-----+           +-v----v-----+
*  >Ŀ  Ŀ     Ŀ |           +>Ŀ |
*    ڿ  ڿ>ڿ  ڿ +--->ڿ  ڿ |             ڿ  ڿ |
*  ų  ų     +ų  -+           +-ų  -+
*   ٳ  ٳ<ٳٳ  ٳ<----+ٳ  ٳ             | ٳ  ٳ
*   ^  ^<    ^^<+           | ^^<+
*  ĳĳ-------------+           +----------+
*    ſ               ſ       ſ   ſ                ſ   ſ
*                                                      
*                                                
*  ppHeadPrev     ppTailNext  ppNodePrev                ppNodePrev
*                                   ppNodeNext       Ŀ   ppNodeNextĿ
*                                                                   
*                                                                 
*                                                     >undefined<
*                                                 ppHeadPrev  ppTailNext
*
***************************************************************************/


/**************************************************************************
**   CDLLInsHead                                                         **
***************************************************************************
*
* ARGUMENTS: See figure below
*
*     pNode       -  ptr to PREVIOUSLY ALLOCATED STRUCTURE
*     ppNodeNext  -  ptr to Next pointer inside new Node
*     ppNodePrev  -  ptr to Prev pointer inside new Node
*     ppTailNext  -  ptr to Next pointer inside last Node of existing list
*     ppHeadPrev  -  ptr to Prev pointer inside first Node of existing list
*     ppTail      -  ptr to Tail pointer of list
*
* RETURN:
*     0           - OK
*
* DESCRIPTION: Insert a node at the Head of a circular doubly linked list
*
*
*      INSERT INTO A NON-EMPTY LIST               INSERT INTO AN EMPTY LIST
*                                Ŀ                Ŀ
*                          ppTail                  ppTail pNode
*         Ŀ                      Ŀ             Ŀ  Ŀ
*    pNode                      >             >    
*                                                    
*                                                       |    
*   +------v--------vĿ          +-v----v-----+
*   +>Ŀ    >Ŀ  Ŀ           +>Ŀ |
*     ڿ  ڿ+---->ڿ  ڿ>ڿ  ڿ             ڿ  ڿ |
*   +-ų  +   ų  ų            +-ų  -+
*   | ٳ  ٳ<---+ ٳ  ٳ<ٳٳ  ٳ            | ٳ  ٳ
*   | ^^     ^  ^<          | ^^<+
*   +-------------ĳĳ          +----------+
*     ſ   ſ       ſ               ſ               ſ   ſ
*                                                      
*                                                
*  ppNodePrev       ppHeadPrev     ppTailNext           ppNodePrev
*        ppNodeNext                                  Ŀ   ppNodeNextĿ
*                                                                   
*                                                                 
*                                                     >undefined<
*                                                 ppHeadPrev  ppTailNext
*
*                                                  (YOU CAN SET THESE TWO
*                                                   TO ANYTHING YOU WANT)
*
***************************************************************************/


/**************************************************************************
**   CDLLDelNode                                                         **
***************************************************************************
*
* ARGUMENTS: See figure below
*
*     ppNodeNext  -  ptr to Next pointer inside new Node
*     ppNodePrev  -  ptr to Prev pointer inside new Node
*     ppPredNext  -  ptr to Next pointer inside predecessor Node of existing list
*     ppSuccPrev  -  ptr to Prev pointer inside successor Node of existing list
*     ppTail      -  ptr to Tail pointer of list
*
* RETURN:
*     pNode       -  ptr to deleted structure. CALLING PROC MUST FREE STRUCT
*     NULL        -  Tail pointer was NULL, no nodes to delete
*
* DESCRIPTION: Delete a node in a circular doubly linked list
*
*
*     DELETE NODE IN MIDDLE OF LIST
*                           Ŀ
*                     ppTail 
*          returnsĿ        Ŀ
*            pNode         > 
*                            
*                  |             
* |ĳĿ
*            +----v------+      v                 DELETE LAST NODE IN LIST
* >Ŀ| Ŀ+>Ŀ 
*   ڿ  ڿ|>ڿ  ڿ>ڿ  ڿ              Ŀ       returns
* ų  ųXXų                ppTail pNode
*  ٳ  ٳ<ٳٳ  ٳ<|ٳ  ٳ                 Ŀ  Ŀ
*  ^<+^^ |^<              >    
*            +---------+                              
* ĳĳĳĳ           NULL<---+    |
*         ſ   ſ   ſ   ſ                          vvĿ
*                                                >Ŀ 
*                                              ڿ  ڿ 
*            ppNodePrev   ppSuccPrev                     ųXX
*    ppPredNext    ppNodeNext                             ٳ  ٳ
*                                                         ^^^^<
*                                                        ĳĳ
*                                                       ٳ    Ŀ
*             DELETE NODE AT TAIL OF LIST              ſ  ſ  ſ  ſ
*                         Ŀ                                    
*                   ppTail                                 
*                          Ŀ  Ŀ             ppSuccPrev ppNodeNext
*                          >    returns           ppNodePrev  ppPredNext
*                                 pNode
*                     +--------+    |
*             v+vvĿ
*             >Ŀ| Ŀ 
*               ڿ  ڿ|>ڿ  ڿ 
*             ų  ųXX
*              ٳ  ٳ<ٳٳ  ٳ
*              ^^<+^^<
*             ĳĳ+ĳĳ
*               ſ   ſ   ſ   ſ
*                            
*                        
*          ppSuccPrev    ppNodePrev
*                ppPredNext    ppNodeNext
*
*****************************************************************************/


/***************************************************************************
**   CLLInsTail                                                           **
****************************************************************************
*
* ARGUMENTS: See figure below
*
*    pNode       -  ptr to PREVIOUSLY ALLOCATED STRUCTURE
*    ppNodeNext  -  ptr to Next pointer inside new Node
*    ppTailNext  -  ptr to Next pointer inside last Node of existing list
*    ppTail      -  ptr to Tail pointer of list
*
*
* RETURN:
*     0           - OK
*
* DESCRIPTION: Insert a node at the tail of a circularly singly linked list
*
*
*    INSERT INTO A NON-EMPTY LIST                 INSERT INTO AN EMPTY LIST
*         Ŀ                                            Ŀ
*   ppTail                                              ppTail pNode
*           Ŀ             Ŀ                         Ŀ  Ŀ
*          >         pNode                         >    
*                                                         
*               +------------+                                |    
*  v-------v--v--+                         +-v----v--+
*  >Ŀ  Ŀ     Ŀ |                         +>Ŀ |
*      ڿ    ڿ       ڿ |                             ڿ |
*      >  ---->  -+                             -+
*      ٳ    ٳ        ٳ                               ٳ
*      ^      ^                             ^
*                                               Ŀ              
*                ſ          ſ                               ſ
*                                                           
*                                            >undefined   
*              ppTailNext  ppNodeNext           ppTailNext      ppNodeNext
*
***************************************************************************/


/***************************************************************************
**   CLLInsHead                                                           **
****************************************************************************
*
* ARGUMENTS: See figure below
*
*    pNode       -  ptr to PREVIOUSLY ALLOCATED STRUCTURE
*    ppNodeNext  -  ptr to Next pointer inside new Node
*    ppTailNext  -  ptr to Next pointer inside last Node of existing list
*    ppTail      -  ptr to Tail pointer of list
*
*
* RETURN:
*     0           - OK
*
* DESCRIPTION: Insert a node at the Head of a circularly singly linked list
*
*
*    INSERT INTO A NON-EMPTY LIST                 INSERT INTO AN EMPTY LIST
*                     Ŀ                                Ŀ
*               ppTail                                  ppTail pNode
*        Ŀ            Ŀ                             Ŀ  Ŀ
*   pNode            >                             >    
*                                                         
*                                                            |    
*  +------v-----vĿ                          +-v----v--+
*  +>Ŀ   >Ŀ  Ŀ                           +>Ŀ |
*      ڿ       ڿ    ڿ                               ڿ |
*      ---->  >                                -+
*      ٳ       ٳ    ٳ                                ٳ
*    ^       ^                              ^
*                                               Ŀ              
*       ſ                  ſ                                ſ
*                                                           
*                                            >undefined   
*    ppNodeNext            ppTailNext           ppTailNext      ppNodeNext
*
***************************************************************************/


/**************************************************************************
**   CLLDelNode                                                          **
***************************************************************************
*
* ARGUMENTS: See figure below
*
*     ppNodeNext  -  ptr to Next pointer inside new Node
*     ppPredNext  -  ptr to Next pointer inside predecessor Node of existing list
*     pPredNode   -  ptr to predecessor node
*     ppTail      -  ptr to Tail pointer of list
*
* RETURN:
*     pNode       -  ptr to deleted structure. CALLING PROC MUST FREE STRUCT
*     NULL        -  Tail pointer was NULL, no nodes to delete
*
* DESCRIPTION: Delete a node in a circular singly linked list
*
*
*   DELETE NODE IN MIDDLE OF LIST
*                          Ŀ
*                           ppTail
*       returnsĿ     Ŀ 
*         pNode       <
*                   
*                      
* ĳĳĿ
*         +----v---+   v                       DELETE LAST NODE IN LIST
* >Ŀ| Ŀ+>Ŀ 
*     ڿ|   ڿ    ڿ                       Ŀ       returns
*     >XX>                         ppTail pNode
* >  ٳ    ٳ    ٳ                          Ŀ  Ŀ
*  ^  ^                           >    
*                                                        
*                                               NULL<---+    |
*ſ   ſ      ſ                                      vvĿ
*                                                  >Ŀ 
*                                                   ڿ 
*    ppPredNext                                            XX
*pPredNode   ppNodeNext                                >  ٳ
*                                                         ^^
*                                                             
*                                                           Ŀ
*            DELETE NODE AT TAIL OF LIST              ſ   ſ    ſ
*                    Ŀ                                        
*              ppTail                                      
*                     Ŀ Ŀ                   pPredNode      ppPredNext
*                     >   returns                   ppNodeNext
*                           pNode
*                  +------+   |
*             v+vvĿ
*             >Ŀ| Ŀ 
*                 ڿ|   ڿ 
*                 +>XX
*             >  ٳ    ٳ
*              ^  ^
*                          
*            ſ   ſ      ſ
*                        
*                     
*                ppPredNext
*          pPredNode      ppNodeNext
*
*****************************************************************************/


/**************************************************************************
**   CLLDelHead                                                          **
***************************************************************************
*
* ARGUMENTS: See figure below
*
*     ppHeadNext  -  ptr to Next pointer inside new Node
*     ppTailNext  -  ptr to Next pointer inside predecessor Node of existing list
*     ppTail      -  ptr to Tail pointer of list
*
* RETURN:
*     pNode       -  ptr to deleted structure. CALLING PROC MUST FREE STRUCT
*     NULL        -  Tail pointer was NULL, no nodes to delete
*
* DESCRIPTION: Delete the node at the Head of a circular doubly linked list
*
*
* DELETE NODE AT HEAD OF NON-EMPTY LIST         DELETE LAST NODE IN LIST
*                          Ŀ
*                           ppTail                Ŀ       returns
*    Ŀreturns        Ŀ                        ppTail pNode
*       pNode         <                         Ŀ  Ŀ
*                                              >    
*                                                        
* ĳ+ĳĿ                   NULL<---+    |
*    v    |            v                              vvĿ
* >Ŀ+>Ŀ  Ŀ                          >Ŀ 
*     ڿ    ڿ    ڿ                              ڿ 
*   XX>  >                             XX
*     ٳ    ٳ    ٳ                               ٳ
*   ^    ^                             ^^
*                                                           
*                                                         Ŀ
*      ſ               ſ                               ſ    ſ
*                                                            
*                                                        
*    ppHeadNext       ppTailNext                                 ppTailNext
*                                                        ppHeadNext
*
*****************************************************************************/
