/*
 *   dspio.c -- DSP FIle I/O routines 
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "dspmgr.h"

#include "dspio.h"                     // Include function prototypes
#include "dsppcmem.h"                  // Include memory calls

/**************************START OF SPECIFICATIONS **************************/
/*                                                                          */
/* SUBROUTINE NAME:  DspReadTagHeader                                       */
/*                                                                          */
/* DISCRIPTIVE NAME: Read a Tag Header from the .DSP file.                  */
/*                                                                          */
/* FUNCTION:         Same                                                   */
/*                                                                          */
/* NOTE:                                                                    */
/*   DEPENDENCIES:   NONE                                                   */
/*                                                                          */
/*   RESTRICTIONS:   NONE                                                   */
/*                                                                          */
/*                                                                          */
/* ENTRY POINTS:     DspReadTagHeader                                       */
/*                                                                          */
/* INPUT:            hfile                                                  */
/*                                                                          */
/* EXIT-NORMAL:                                                             */
/*                   pTag        - pointer to the Tag String                */
/*                   pulBodySize - pointer to body size.                    */
/*                   pulTagSize  - pointer to tag size.                     */
/*                                                                          */
/* EXTERNAL REFERENCES: System Calls                                        */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/************************** END OF SPECIFICATIONS ***************************/

RC ReadTagHdr(HFILE hfile,PVOID pTag,PULONG pulBodySize,PULONG pulTagSize)
{
   RC         ulRc;

   struct {
      ULONG      Tag;
      ULONG      Bodysize;
   }

   TagHeader;

   /*************************************************************************/
   /*   Read eight bytes from the file to get tag header.                   */
   /*   Tag Header is tag string and body size.                             */
   /*************************************************************************/
/*  Read both tag & bodysize into structure with one call                   */

   MW_SYSLOG_3(TRACE_MANAGER_CORE,"dspio::ReadTagHdr entry hfile %x pTag %x\n",(int)hfile,(int)pTag);

   if ((ulRc = DspReadFile(hfile, (LONG)TAGHEADERSIZE, &TagHeader)) !=
        DSP_NOERROR)
      return (ulRc);

   /*************************************************************************/
   /*   The total tag size is the body size + tag header size.              */
   /*   Add 1 if the result is odd.                                         */
   /*************************************************************************/

   if (TagHeader.Bodysize&1)
      TagHeader.Bodysize += 1;

   *((ULONG *)pTag) = TagHeader.Tag;
   *pulTagSize = TagHeader.Bodysize+TAGHEADERSIZE;
   *pulBodySize = TagHeader.Bodysize;

   /*************************************************************************/
   /*   The total body size should be adjusted to an even number            */
   /*   also. Note that this might go away if it gets complicated.          */
   /*************************************************************************/

   MW_SYSLOG_1(TRACE_MANAGER_CORE,"dspio::ReadTagHdr exit ulRC=0\n");
   return (DSP_NOERROR);

}                                      /* End ReadTagHdr                    */
