const char glsl_bilinear_rgb32_lut_fsh_src[] =
"\n"
"#pragma optimize (on)\n"
"#pragma debug (off)\n"
"\n"
"uniform sampler2D     color_texture;\n"
"uniform sampler2D     colortable_texture;\n"
"uniform vec2          colortable_sz;      // orig size\n"
"uniform vec2          colortable_pow2_sz; // pow2 ct size\n"
"uniform vec2          color_texture_pow2_sz; // pow2 tex size\n"
"\n"
"vec4 lutTex2D(in vec2 texcoord)\n"
"{\n"
"	vec4 color_tex;\n"
"	vec2 color_map_coord;\n"
"	vec4 color0;\n"
"	float colortable_scale = (colortable_sz.x/3.0) / colortable_pow2_sz.x;\n"
"\n"
"	// normalized texture coordinates ..\n"
"	color_tex         = texture2D(color_texture, texcoord) * ((colortable_sz.x/3.0)-1.0)/colortable_pow2_sz.x;// lookup space \n"
"\n"
"	color_map_coord.x = color_tex.b;\n"
"	color0.b          = texture2D(colortable_texture, color_map_coord).b;\n"
"\n"
"	color_map_coord.x = color_tex.g + colortable_scale;\n"
"	color0.g          = texture2D(colortable_texture, color_map_coord).g;\n"
"\n"
"	color_map_coord.x = color_tex.r + 2.0 * colortable_scale;\n"
"	color0.r          = texture2D(colortable_texture, color_map_coord).r;\n"
"\n"
"	return color0;\n"
"}\n"
"\n"
"void main()\n"
"{\n"
"	vec2 xy = gl_TexCoord[0].st;\n"
"\n"
"	// mix(x,y,a): x*(1-a) + y*a\n"
"	//\n"
"	// bilinear filtering includes 2 mix:\n"
"	//\n"
"	//   pix1 = tex[x0][y0] * ( 1 - u_ratio ) + tex[x1][y0] * u_ratio\n"
"	//   pix2 = tex[x0][y1] * ( 1 - u_ratio ) + tex[x1][y1] * u_ratio\n"
"	//   fin  =    pix1     * ( 1 - v_ratio ) +     pix2    * v_ratio\n"
"	//\n"
"	// so we can use the build in mix function for these 2 computations ;-)\n"
"	//\n"
"	vec2 uv_ratio     = fract(xy*color_texture_pow2_sz); // xy*color_texture_pow2_sz - floor(xy*color_texture_pow2_sz);\n"
"	vec2 one          = 1.0/color_texture_pow2_sz;\n"
"\n"
"	vec4 col1, col2;\n"
"\n"
"	col1 = mix( lutTex2D(xy                   ), lutTex2D(xy + vec2(one.x, 0.0)), uv_ratio.x);\n"
"	col2 = mix( lutTex2D(xy + vec2(0.0, one.y)), lutTex2D(xy + one             ), uv_ratio.x);\n"
"\n"
"	gl_FragColor =  mix ( col1, col2, uv_ratio.y );\n"
"}\n"
"\n"
"\n"
;
