/****************************************************************************
 **
 ** $Id: CvsDirectory.h,v 1.20 2005/01/10 01:42:35 frank Exp $
 **
 ** Copyright (C) 1999-2004 The LinCVS development team.
 **    Tilo Riemer <riemer@lincvs.org>
 **    Falk Brettschneider <gigafalk@yahoo.com>
 **    Frank Hemer <frank@hemer.org>
 **    Wim Delvaux <wim.delvaux@chello.be>
 **    Jose Hernandez <joseh@tesco.net>
 **    Helmut Koll <HelmutKoll@web.de>
 **    Tom Mishima <tmishima@mail.at-m.or.jp>
 **    Joerg Preiss <auba@auba.de>
 **    Sven Trogisch <trogisch@iapp.de>
 **
 **
 **----------------------------------------------------------------------------
 **
 **----------------------------------------------------------------------------
 **
 ** LinCVS is available under two different licenses:
 **
 ** If LinCVS is linked against the GPLed version of Qt 
 ** LinCVS is released under the terms of GPL also.
 **
 ** If LinCVS is linked against a nonGPLed version of Qt 
 ** LinCVS is released under the terms of the 
 ** LinCVS License for non-Unix platforms (LLNU)
 **
 **
 ** LinCVS License for non-Unix platforms (LLNU):
 **
 ** Redistribution and use in binary form, without modification, 
 ** are permitted provided that the following conditions are met:
 **
 ** 1. Redistributions in binary form must reproduce the above copyright
 **    notice, this list of conditions and the following disclaimer in the
 **    documentation and/or other materials provided with the distribution.
 ** 2. It is not permitted to distribute the binary package under a name
 **    different than LinCVS.
 ** 3. The name of the authors may not be used to endorse or promote
 **    products derived from this software without specific prior written
 **    permission.
 ** 4. The source code is the creative property of the authors.
 **    Extensions and development under the terms of the Gnu Public License
 **    are limited to the Unix platform. Any distribution or compilation of 
 **    the source code against libraries licensed other than gpl requires 
 **    the written permission of the authors.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
 ** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 ** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 ** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 ** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 ** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 ** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 ** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 **
 **
 ** LinCVS License for Unix platforms:
 **
 ** This program is free software; you can redistribute it and/or modify 
 ** it under the terms of the GNU General Public License as published by 
 ** the Free Software Foundation; either version 2 of the License, or 
 ** (at your  option) any later version.  This program is distributed in 
 ** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 ** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 ** PARTICULAR PURPOSE.
 **
 ** See the GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **
 *****************************************************************************/


#ifndef CVSDIRECTORY_H
#define CVSDIRECTORY_H

#include "directory.h"
#include "FileListViewItem.h"
#include "CCvsEntries.h"

class CvsDirectory : public Directory {

 public:

   CvsDirectory( QStringList, const QString& fileName);
   
   CvsDirectory( QListViewItem * parent,
	 const QString& fileName,
	 bool virtualDir);

   virtual ~CvsDirectory();
   virtual int rtti() const;
   CvsDirectory * firstChild();
   CvsDirectory * nextSibling();
   CvsDirectory * dyncast_cvsdir(QListViewItem *);

   
 protected:


 private:

   //inherited virtual methods
   Directory * createChild( const QString&, bool=false);
   int getType() {return Cvs;}
   bool loginOk(CCvsOutput*,bool = false);
   void removeLogin(CCvsOutput*);
   bool isModified();
   bool isControlledTree();
   bool checkDirForControl();
   void recCheckForModifications(bool);
   bool postCallCheck(int=Controled|NonControled|Ignored);
   void validateControlledFilesStatus(bool=false, bool=false, bool=false);
   void checkAndShowStatus(FileListViewItem * =0, bool=false, int=Controled|NonControled|Ignored, bool=false);
   void checkAndUpdateFileCache(QString&);
   void removeTmpEntries(QString=QString::null);
   void recRemoveTmpEntries(bool);
   bool recCopyTree(QString,QString,bool=false);
   bool parseCallResult(CvsBuffer*, int, QStringList * =0);
   bool isControlled(QString);
   bool isBinary(QString);
   bool analyzeDirs();
   Entries * getEntries(bool=false);
   const QString getHomeFilesToIgnore(QDateTime&, bool&);
   const QString getDirFilesToIgnore(const QString, bool&);
   void getNameAndRevOfFirstSelectedFile(QString *, QString *);
   QString getRev(QString *);
   bool backupFiles(QStringList);
   bool restoreFiles(QStringList);
   
   //local methods
   void init(const QString& fileName);
   void fillFileListWithEntries(QStringList& fileList);
   void fillFileListWithFullNameEntries(QStringList& fileList);
   QString rcsToFileName(QString);
   void removeFileNameInconsistencies(QString &);
   
   CvsEntries * getCvsEntries(bool=false);
   EntryStates alignWithEntries(QString name, EntryStates stateId);
   bool setAndAppendTmpEntryQueryUpdate(QString); //special case for query-update files missing and not in CVS/Entries
   inline FileListViewItem * setStatusInFileListView(FileListViewItem *,Entry *,bool=false);
   inline QString getState(const EntryStates &);
   inline char * getPix(const EntryStates &,const int &);
   
   bool isFilesModified();
   bool entriesFileModified();
   bool entriesLogFileModified();

   //local variables
   CvsEntries m_CvsEntries;
   QStringList m_tmpEntries;
   
   bool m_entriesCached;
   bool m_checkedForIgnoresFile;
   
   QDateTime m_lastTimeHomeIgnoresChanged;
   QDateTime m_lastTimeDirIgnoresChanged;
   QString m_pDirIgnores;
   
};
#endif
