/****************************************************************************
 **
 ** $Id: AutoCheck.cpp,v 1.3 2004/12/20 02:42:10 frank Exp $
 **
 ** Copyright (C) 2001-2004 Tilo Riemer <riemer@lincvs.org> and
 **                         Frank Hemer <frank@hemer.org>
 **
 **
 **----------------------------------------------------------------------------
 **
 **----------------------------------------------------------------------------
 **
 ** LinCVS is available under two different licenses:
 **
 ** If LinCVS is linked against the GPLed version of Qt 
 ** LinCVS is released under the terms of GPL also.
 **
 ** If LinCVS is linked against a nonGPLed version of Qt 
 ** LinCVS is released under the terms of the 
 ** LinCVS License for non-Unix platforms (LLNU)
 **
 **
 ** LinCVS License for non-Unix platforms (LLNU):
 **
 ** Redistribution and use in binary form, without modification, 
 ** are permitted provided that the following conditions are met:
 **
 ** 1. Redistributions in binary form must reproduce the above copyright
 **    notice, this list of conditions and the following disclaimer in the
 **    documentation and/or other materials provided with the distribution.
 ** 2. It is not permitted to distribute the binary package under a name
 **    different than LinCVS.
 ** 3. The name of the authors may not be used to endorse or promote
 **    products derived from this software without specific prior written
 **    permission.
 ** 4. The source code is the creative property of the authors.
 **    Extensions and development under the terms of the Gnu Public License
 **    are limited to the Unix platform. Any distribution or compilation of 
 **    the source code against libraries licensed other than gpl requires 
 **    the written permission of the authors.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
 ** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 ** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 ** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 ** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 ** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 ** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 ** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 **
 **
 ** LinCVS License for Unix platforms:
 **
 ** This program is free software; you can redistribute it and/or modify 
 ** it under the terms of the GNU General Public License as published by 
 ** the Free Software Foundation; either version 2 of the License, or 
 ** (at your  option) any later version.  This program is distributed in 
 ** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 ** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 ** PARTICULAR PURPOSE.
 **
 ** See the GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **
 *****************************************************************************/

#include "AutoCheck.h"

#include <qapplication.h>
#include <assert.h>

#include "globals.h"
#include "Status.h"
#include "Update.h"

AutoCheck * AutoCheck::autoCheck(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench)
{
   return setup(whatsThisIconSet, parent, workBench);
}

AutoCheck * AutoCheck::setup(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench) {
   DirBase * dir = workBench->selectedItem();
   AutoCheck * p = new AutoCheck(whatsThisIconSet, parent, workBench, dir);
   p->acceptCvs();
   return NULL;
}

AutoCheck::AutoCheck(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, DirBase * dir)
   :  m_whatsThisIconSet(whatsThisIconSet),
      m_parent(parent),
      m_workBench(workBench),
      m_dir(dir),
      m_blocked(false),
      m_lastChecked(""),
      m_lastSubChecked("")
{
   connect(this,SIGNAL(deleteObject(QObject *)),parent,SLOT(slot_deleteObject(QObject *)));
   connect(this,SIGNAL(blockGUI(bool)),parent,SLOT(slot_blockGUI(bool)));
}

AutoCheck::~AutoCheck() {
}

void AutoCheck::acceptCvs() {

   if (!m_blocked) {
      emit blockGUI(true);
      m_blocked = true;
   }

   QStringList projectNameList;
   projectSettings->getTopLevelProjects(projectNameList);

   int from = 0;
   if (!m_lastChecked.isEmpty()) {
      if (m_lastSubChecked.isEmpty()) {
	 from = projectNameList.findIndex( m_lastChecked) + 1;
      } else {
	 from = projectNameList.findIndex( m_lastChecked);
      }
   }

   for(unsigned int i = (unsigned int)from; i < projectNameList.count(); i++) {

      QString moduleName = projectNameList[i];
      QStringList subProjectNameList;
      projectSettings->getSubProjects(moduleName,subProjectNameList);

      if (subProjectNameList.isEmpty()) {

	 if (autoUpdate(moduleName)) {
	    m_lastChecked = moduleName;
	    return;
	 }

      } else {

	 int subFrom = 0;
	 if (!m_lastSubChecked.isEmpty()) {
	    subFrom = subProjectNameList.findIndex( m_lastSubChecked) + 1;
	 }
    
	 for(unsigned int j = (unsigned int)subFrom; j < subProjectNameList.count(); j++) {
      
	    QString subProject = subProjectNameList[j];
	    if (autoUpdate(subProject)) {
	       m_lastChecked = moduleName;
	       m_lastSubChecked = subProject;
	       return;
	    }
	 }
	 m_lastSubChecked = "";

	 if (autoUpdate(moduleName)) {
	    m_lastChecked = moduleName;
	    return;
	 }

      }
   }

   reject();
}

bool AutoCheck::autoUpdate(QString module) {

   int autoupdate;
   QString workdir;
   QStringList disabled;

   projectSettings->get(module,WORKDIR,workdir);
   projectSettings->get(module,DISABLED,disabled);

   if (disabled.find(workdir) != disabled.end()) return FALSE;
   m_callDir = m_workBench->find(workdir);
   if (m_callDir && !m_callDir->isDisabled() ) {
      projectSettings->get(module,PAUTOUPDATE,autoupdate);
   } else return FALSE;

   switch(autoupdate) {
      case AutoUpdate::OFF: {
	 return false;
	 break;
      }
      case AutoUpdate::QUERY: {
	 Update::queryUpdateAuto(m_whatsThisIconSet,m_parent,m_workBench,m_callDir,this);
	 break;
      }
      case AutoUpdate::QUERYALL: {
	 Update::queryUpdateAllAuto(m_whatsThisIconSet,m_parent,m_workBench,m_callDir,this);
	 break;
      }
      case AutoUpdate::STATUS: {
	 Status::statusAuto(m_whatsThisIconSet,m_parent,m_workBench,m_callDir,this);
	 break;
      }
      case AutoUpdate::UPDATE: {
	 Update::updateAuto(m_whatsThisIconSet,m_parent,m_workBench,m_callDir,this);
	 break;
      }
      case AutoUpdate::UPDATEALL: {
	 Update::updateAuto(m_whatsThisIconSet,m_parent,m_workBench,m_callDir,this);
	 break;
      }
      default: {
	 return false;
      }
   }
   return true;
}

void AutoCheck::callDone(bool ok) {
   if (ok) {
      if (m_dir && m_callDir && m_dir->fullName().startsWith(m_callDir->fullName()) ) {//subDir of selected dir might have changed
	 m_dir->activateItem(false);
      }
      acceptCvs();
   } else {
      reject();
   }
}

void AutoCheck::reject() {
   emit deleteObject(this);
}
