/*
 * Decompiled with CFR 0.152.
 */
package org.yecht.ruby;

import org.jruby.Ruby;
import org.jruby.RubyNumeric;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.yecht.IoStrRead;
import org.yecht.JechtIO;
import org.yecht.Pointer;

public class RubyIoStrRead
implements IoStrRead {
    private IRubyObject port;

    public RubyIoStrRead(IRubyObject port) {
        this.port = port;
    }

    public int read(Pointer buf, JechtIO.Str str, int max_size, int skip) {
        int len = 0;
        if ((max_size -= skip) <= 0) {
            max_size = 0;
        } else {
            IRubyObject src = this.port;
            RubyNumeric n = RubyNumeric.int2fix((Ruby)this.port.getRuntime(), (long)max_size);
            IRubyObject str2 = src.callMethod(this.port.getRuntime().getCurrentContext(), "read", (IRubyObject)n);
            if (!str2.isNil()) {
                ByteList res = str2.convertToString().getByteList();
                len = res.realSize;
                System.arraycopy(res.bytes, res.begin, buf.buffer, buf.start + skip, len);
            }
        }
        buf.buffer[buf.start + (len += skip)] = 0;
        return len;
    }
}

