/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.alignments;

import edu.cornell.med.icb.goby.alignments.Alignments;

public class EntryFlagHelper {
    public static boolean isPaired(Alignments.AlignmentEntry entry) {
        return ((long)entry.getPairFlags() & 1L) != 0L;
    }

    public static boolean isProperlyPaired(Alignments.AlignmentEntry entry) {
        return ((long)entry.getPairFlags() & 2L) != 0L;
    }

    public static boolean isReadUnmapped(Alignments.AlignmentEntry entry) {
        return ((long)entry.getPairFlags() & 4L) != 0L;
    }

    public static boolean isMateUnmapped(Alignments.AlignmentEntry entry) {
        return ((long)entry.getPairFlags() & 8L) != 0L;
    }

    public static boolean isReadReverseStrand(Alignments.AlignmentEntry entry) {
        return ((long)entry.getPairFlags() & 0x10L) != 0L;
    }

    public static boolean isMateReverseStrand(Alignments.AlignmentEntry entry) {
        return ((long)entry.getPairFlags() & 0x20L) != 0L;
    }

    public static boolean isFirstInPair(Alignments.AlignmentEntry entry) {
        return ((long)entry.getPairFlags() & 0x40L) != 0L;
    }

    public static boolean isSecondInPair(Alignments.AlignmentEntry entry) {
        return ((long)entry.getPairFlags() & 0x80L) != 0L;
    }

    public static boolean isNotPrimaryAlignment(Alignments.AlignmentEntry entry) {
        return ((long)entry.getPairFlags() & 0x100L) != 0L;
    }

    public static boolean isNormalSplice(Alignments.AlignmentEntry entry) {
        return ((long)entry.getSplicedFlags() & 1L) != 0L;
    }

    public static boolean isNovelSplice(Alignments.AlignmentEntry entry) {
        return ((long)entry.getSplicedFlags() & 2L) != 0L;
    }
}

