package org.broad.tribble;


/**
 * Represents a locus on a reference sequence.   The coordiante conventions are 1-based fully closed.  For example,
 * a features  spanning the second and third base of a sequence would have coordinates start = 2,  end = 3,  and
 * a length of 2.
 */
public interface Feature {

    /**
     * Return the features reference sequence name, e.g chromosome or contig
     */
    public String getChr();

    /**
     * Return the start position in 1-based coordinates (first base is 1)
     */
    public int getStart();

    /**
     * Return the end position following 1-based fully closed conventions.  The length of a feature is
     * end - start + 1;
     */
    public int getEnd();
}
