/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */

// floater.tcl

#ifdef TEXT
if {[info tclversion] < 8.0} {
    puts stderr "You have compiled Floater with Tcl [info tclversion]"
    puts stderr "You must recompile with Tcl 8.0 or higher"
    exit 1
}
#else
if {[info tclversion] < 8.0 || $tk_version < 8.0} {
    puts stderr "You have compiled Floater with Tcl [info tclversion]/Tk $tk_version."
    puts stderr "You must recompile with Tcl/Tk 8.0 or higher."
    exit 1
}
#endif

#include "gset.deq"
gset floater_version "Floater 1.2b1"
#include "errorhandle.deq"
#include "files.deq"
#include "connect.deq"
#include "mail.deq"
#include "seen.deq"
#include "logo.deq"
#include "texts.deq"
#if 0
#include "resultreq.deq"
#endif


gset floaterclock 0
gset table_arrival_time 0
gset snooze 0

#ifdef TEXT
#if 0
#define DEBUG
proc clearrect {x y} {puts stdout "clearrect $x $y"}
proc anchor {l} {puts stdout "anchor $l"}
proc down_and_anchor {{l 1}} {puts stdout "down_and_anchor $l"}
proc right {{l 1}} {puts stdout "right $l"}
proc str {l} {puts stdout "str `$l'"}
proc ch {l} {puts stdout "ch $l"}
#endif
#endif

/////////////////////////////////////////////////////////////////////////////

gset ntalklines 0 // number of talklines (all may not be displayed, though)

gset dtalklines 0 // display as if there were this many talklines
		  // (this one goes at the bottom of the screen) 

gset talklineattop 0 // which of talklines( ) is at the top of the display
// gset talktop 17 // y coord of the first talk line
// gset talkbottom 24 // y coord of the bottom talk line

gset showerrors 1
gset debugprinting 0

#ifdef TEXT
if $floater_silent {
    proc clearrect {x y} {puts stdout "clearrect $x $y"}
    proc anchor {l} {puts stdout "anchor $l"}
    proc down_and_anchor {{l 1}} {puts stdout "down_and_anchor $l"}
    proc right {{l 1}} {puts stdout "right $l"}
    proc str {l} {puts stdout "str `$l'"}
    proc ch {l} {puts stdout "ch $l"}
}

proc talkmsg {s {draw 1} {allowPrefix 1}} {
    global talklines ntalklines talkwidth debugprinting showerrors
    global dtalklines scrolllock talktop floater_silent floater_silent_conns

    if $floater_silent {
	puts $s
	global conn_to_sock
	foreach conn [array names floater_silent_conns] {
	    catch {puts $conn_to_sock($conn) $s}
	}
	return
    }

#if DEBUG
    if {$debugprinting && $allowPrefix} {set s "DEBUG> $s"}
#else
    if $debugprinting return
#endif
    if {$talktop < 0} return
    if {!$showerrors && [regexp -nocase error $s]} return
    
    // Recursively handle piece before \n and piece after
    if [regexp "(.*)\n(.*)" $s whole a b] {
	talkmsg $a
	talkmsg $b
	return
    }
    
    if {[string length $s] > $talkwidth} {
	// try to break at a space
	for {set i $talkwidth} {[incr i -1] > 0} {} {
	    if {[string index $s $i] == " "} {
		incr i -1
		talkmsg [string range $s 0 $i] 0 0
		talkmsg [string range $s [expr $i + 2] end] $draw 0
		return
	    }
	}
	// no space to break at, so break at right margin
	talkmsg [string range $s 0 [expr $talkwidth - 1]] 0 0
	talkmsg [string range $s $talkwidth end] $draw 0
	return
    }

    set talklines($ntalklines) $s
    incr ntalklines
    if !$scrolllock {set dtalklines $ntalklines}
    if $draw {drawtalkregion}
}
#else
proc talkmsg {s} {
    global talktext debugtext debugprinting showerrors

    if $debugprinting then { set w $debugtext } else { set w $talktext }

    if {!$showerrors && [regexp -nocase error $s]} return

    catch {
	$w insert end "$s\n"
	$w yview -pickplace end
    }
}
#endif

proc floatererror {s} { talkmsg "ERROR: $s" }

/////////////////////////////////////////////////////////////////////////////

#ifndef NO_FLOATER_FILES
// load startup file first
if {[catch {source $startupfile} err] \
	&& ![regexp -nocase {no such file} $err]} {
#ifdef TEXT
    talkmsg "ERROR: $err"
#else
    puts stderr $err
#endif
}
#endif /* NO_FLOATER_FILES */

#if 0
tryset loginserveraddr "128.32.34.45"
tryset resultserveraddr "128.32.34.45"
tryset pseudomailaddr "128.32.34.45"
#endif
tryset loginservername "loginserver"
tryset loginserveraddr "128.32.131.251"
tryset loginserverport "2210"
tryset resultservername "resultserver"
tryset resultserveraddr "128.32.131.251"
tryset resultserverport "1430"
tryset pseudomailaddr "128.32.131.251"
tryset pseudomailport "1440"
tryset resultparserprogram /home/cs/pike/floater/floatres/parsemail
tryset resultparser "floater@floater.org"
tryset bugmail "pike@cs.berkeley.edu" ; # "bugs@floater.org"

// tryset defaultnote "need 3"
tryset defaultnote ""

// time (in ms) to wait before erasing a trick and displaying the next trick
tryset tricktime 2000

// default number of seconds to wait before automatically dealing the next hand
// (used to reset autonewdeal_seconds at user request)
#ifdef DEBUG
tryset autonewdeal_default 45
#else
tryset autonewdeal_default 35
#endif

// if nonnegative, the number of seconds to wait before dealing the next hand
tryset autonewdeal_seconds $autonewdeal_default

tryset nokibitzers 0
tryset jointableservertree 1

tryset youveseen 1

tryset newbie [expr ![info exists usedname]]

/////////////////////////////////////////////////////////////////////////////
// Geometry
/////////////////////////////////////////////////////////////////////////////
#ifndef TEXT
gset screenheight [winfo screenheight .]
gset screenwidth [winfo screenwidth .]
tryset geometry_specified 0
catch {wm title . "Floater"}
catch {wm minsize . 1 1}
//set w [expr $screenwidth - 100]
//set h [expr $screenheight - 10]
set w 600
set h 800
if {$h >= $screenheight} {
    set h [expr $screenheight - 15]
#ifdef WANT_EXTRA_HEADROOM
    if {$screenheight > 600} {incr h -20}
#endif
}
if !$geometry_specified {catch {wm geometry . [join "$w $h" x]}}
// catch {set geom [wm geometry .]}
// Try to set effectiveheight to the actual height of the main Floater window
//if ![regexp {.*x([0-9]+)} $geom a effectiveheight] {
//    set effectiveheight $screenheight
//}
set effectiveheight $h

//wm geometry . 630x750
//wm geometry . +0-20
#endif /* not TEXT */

/////////////////////////////////////////////////////////////////////////////
// fonts
/////////////////////////////////////////////////////////////////////////////
#ifndef TEXT

#ifdef LARGER_DEFAULT_FONTS
tryset _suitfont(l) "*-symbol-medium-r-normal--*-240-*-*-*-*-*-*"
tryset _cardfont(l) "*-times-medium-r-normal--*-240-*-*-*-*-*-*"
tryset _NTfont(l) "*-times-medium-r-normal--*-180-*-*-*-*-*-*"
tryset _suitfont(m) "*-symbol-medium-r-normal--*-180-*-*-*-*-*-*"
tryset _cardfont(m) "*-times-medium-r-normal--*-180-*-*-*-*-*-*"
tryset _NTfont(m) "*-times-medium-r-normal--*-140-*-*-*-*-*-*"
tryset _suitfont(s) "*-symbol-medium-r-normal--*-120-*-*-*-*-*-*"
tryset _cardfont(s) "*-times-medium-r-normal--*-120-*-*-*-*-*-*"
tryset _NTfont(s) "*-times-medium-r-normal--*-100-*-*-*-*-*-*"
tryset _namefont(l) "*-times-bold-r-normal--*-140-*-*-*-*-*-*"
tryset _namefont(m) "*-times-bold-r-normal--*-140-*-*-*-*-*-*"
tryset _namefont(s) "*-times-bold-r-normal--*-120-*-*-*-*-*-*"
tryset _talkfont(e) "*-new century schoolbook-medium-r-normal--*-240-*-*-*-*-*-*"
tryset _talkfont(l) "*-new century schoolbook-medium-r-normal--*-180-*-*-*-*-*-*"
tryset _talkfont(m) "*-times-medium-r-normal--*-140-*-*-*-*-*-*"
tryset _talkfont(s) "*-new century schoolbook-medium-r-normal--*-120-*-*-*-*-*-*"
#else
tryset _suitfont(l) "*-symbol-medium-r-normal--*-180-*-*-*-*-*-*"
tryset _cardfont(l) "*-times-medium-r-normal--*-180-*-*-*-*-*-*"
tryset _NTfont(l) "*-times-medium-r-normal--*-140-*-*-*-*-*-*"
tryset _suitfont(m) "*-symbol-medium-r-normal--*-120-*-*-*-*-*-*"
tryset _cardfont(m) "*-times-medium-r-normal--*-120-*-*-*-*-*-*"
tryset _NTfont(m) "*-times-medium-r-normal--*-100-*-*-*-*-*-*"
tryset _suitfont(s) "*-symbol-medium-r-normal--*-100-*-*-*-*-*-*"
tryset _cardfont(s) "*-times-medium-r-normal--*-100-*-*-*-*-*-*"
tryset _NTfont(s) "*-times-medium-r-normal--*-80-*-*-*-*-*-*"
tryset _namefont(l) "*-times-bold-r-normal--*-120-*-*-*-*-*-*"
tryset _namefont(m) "*-times-bold-r-normal--*-120-*-*-*-*-*-*"
tryset _namefont(s) "*-times-bold-r-normal--*-100-*-*-*-*-*-*"
tryset _talkfont(e) "*-new century schoolbook-medium-r-normal--*-240-*-*-*-*-*-*"
tryset _talkfont(l) "*-new century schoolbook-medium-r-normal--*-180-*-*-*-*-*-*"
tryset _talkfont(m) "*-new century schoolbook-medium-r-normal--*-140-*-*-*-*-*-*"
tryset _talkfont(s) "*-new century schoolbook-medium-r-normal--*-120-*-*-*-*-*-*"
#endif
tryset _talkfont(8) {Courier 18}
tryset _talkfont(4) {Courier 14}
tryset _talkfont(2) {Courier 12}

#ifdef DEBUG
set talkfont $_talkfont(s) // default to small
set radiotalkfont Small
#else
if {$effectiveheight < 770} {
    set talkfont $_talkfont(s)
    set radiotalkfont Small
} else {
    set talkfont $_talkfont(m)
    set radiotalkfont Medium
}
#endif

// Records the fact that the given widget used the given font, so we can change
// it later if we so desire.
proc refont {widget font} {
    global a_$font fonts widget_to_font

//  puts "refont $widget $font"
    if {[info exists widget_to_font($widget)] && \
	    $widget_to_font($widget) != $font} {
	set oldfont $widget_to_font($widget)
	global a_$oldfont
//	puts "unset a_$oldfont\($widget)"
	catch {eval "unset a_$oldfont\($widget)"}
    }

    eval "set a_$font\($widget) 1"
    set widget_to_font($widget) $font
    set fonts($font) 1
}

// Updates all widgets with the given font.
proc updatefont {font} {
    global a_$font $font

    eval "set new $$font"
    foreach w [array names a_$font] {
//	puts "updatefont $w ($font = $new)"
	if [catch {$w configure -font $new}] {eval "unset a_$font\($w)"}
    }
}

// Updates the font of every widget.
proc updateallfonts {} {
    global fonts

    foreach font [array names fonts] {
	updatefont $font
    }
}

// Changes the font size of the talk window, command line, and talk line.
proc updatetalkfontsize {size} {
    global talkfont _talkfont talktext cmdlinefont cmdlinelabelfont debugtext
    
    if {$talkfont != $_talkfont($size)} {
	$talktext configure -font [set talkfont $_talkfont($size)]
	catch {$debugtext configure -font $talkfont}
    }
    set cmdlinefont $talkfont
    set cmdlinelabelfont $cmdlinefont
    updatefont cmdlinefont
    updatefont cmdlinelabelfont
    after 250 talkbottom
}

// set fonts for future widgets that are created
proc setfontsize {size} {
    global suitfont cardfont NTfont passfont doublefont redoublefont namefont \
	    auctionlabelfont auctionbbfont cmdlinefont cmdlinelabelfont \
	    _suitfont _cardfont _NTfont _namefont talkfont \
	    buttoncardoptions buttonsuitoptions

    set namefont $_namefont($size)
    set suitfont $_suitfont($size)
    set cardfont $_cardfont($size)
    set NTfont $_NTfont($size)
    set passfont $NTfont
    set doublefont $cardfont
    set redoublefont $doublefont
    set auctionlabelfont $passfont
    set auctionbbfont $cardfont
    set cmdlinefont $talkfont
    set cmdlinelabelfont $cmdlinefont
    set buttoncardoptions "-font $cardfont -padx 1 -relief flat"
    set buttonsuitoptions "-font $suitfont -padx 2 -relief flat"
}
#ifdef DEBUG
setfontsize s
#else
setfontsize m // default to medium at startup
#endif

tryset NTtext NT
tryset passtext Pass
tryset doubletext X
tryset redoubletext XX

tryset auctionlabel "The Bidding:"
tryset auctionnamewidth 12

gset suitchar(0) [set club "\247"]
gset suitchar(1) [set diamond "\250"]
gset suitchar(2) [set heart "\251"]
gset suitchar(3) [set spade "\252"]
proc s {} {global spade; return "$spade -fg black"}
proc h {} {global heart; return "$heart -fg red"}
proc d {} {global diamond; return "$diamond -fg red"}
proc c {} {global club; return "$club -fg black"}

//tryset framesuitoptions "-pady 1"
tryset framesuitoptions ""

#endif /* #ifndef TEXT */
/////////////////////////////////////////////////////////////////////////////

gset tcl_interactive 1

set needAuctionUpdate 0

#include "options_common.deq"
#ifndef TEXT
#include "options_GUI.deq"
#include "matrix0.deq"
#include "matrix.deq"
#else
#include "matrix0.deq"
#endif

gset showingauction 0

// the argument to showauction is a boolean---whether to show the auction
#ifdef TEXT
proc showauction {bool} {
    global auctionx auctiony auctionwidth auctionheight auctionright auctionbot
    global showingauction

    set showingauction $bool
    anchor "$auctionx $auctiony"
    clearrect $auctionwidth $auctionheight
    if $bool {
	hline . $auctionx $auctionright $auctiony
	vline . $auctionx $auctiony $auctionbot
    }
    textseated
}
#else
proc showauction {bool} {
    global showingauction

    set showingauction $bool
    if $bool {
	pack .auction -side top -fill both -after .play
    } else {
	pack forget .auction
    }
}
#endif

#ifdef TEXT
// return a string of length width that is s, padded by spaces in front
proc rightjustify {s width {r 1}} {
    while {[string length $s] < $width} {
	set s " $s"
	if $r {ch " "}
    }
    return $s
}
#endif

#ifdef TEXT
proc hline {c xlo xhi y} {
    anchor "$xlo $y"
    for {} {$xlo <= $xhi} {incr xlo} {ch $c}
}

proc vline {c x ylo yhi} {
    anchor "$x $ylo"
    for {} {$ylo <= $yhi} {incr ylo} {ch $c; down_and_anchor}
}

// draw the matrix
hline - 30 46 4
hline - 30 46 10
vline | 29 5 9
vline | 47 5 9
// where players' hands are drawn in the matrix
// (Note: mframe is used quite differently if we have Tk)
gset mframe(self) {30 11}
gset mframe(pard) {30 0}
gset mframe(lho) {15 6}
gset mframe(rho) {49 6}
gset handwidth 14
// where to put player names
gset namewidth 14
gset namepos(self) {15 11}
gset namepos(pard) {15 0}
gset namepos(lho) {15 5}
gset namepos(rho) {49 5}
// where bids are drawn inside the matrix
gset matrixtext(self) {37 9}
gset matrixtext(pard) {37 5}
gset matrixtext(lho) {31 7}
gset matrixtext(rho) {43 7}
// where the auction is shown (to the right of the matrix)
gset auctionx 64
gset auctiony 5
gset auctionright 79
gset auctionbot 14
gset auctionwidth [expr $auctionright - $auctionx + 1]
gset auctionheight [expr $auctionbot - $auctiony + 1]
#endif

#ifndef TEXT


//pulldown menu
//frame .menu -relief raised -borderwidth 1 -width 7i -height 1
menu .menu -tearoff 0
#include "menu.deq"
. configure -menu .menu

//status line
label .stat

//info line
label .infoline

//the matrix
if $newstyle_matrix {
    canvsetup .play
} else {
    frame .play

    frame .play.middle
    frame .play.middle.top
    frame .play.middle.top.pard
    pack .play.middle.top.pard
    frame .play.middle.box -relief raised -borderwidth 4
    frame .play.middle.bottom
    frame .play.middle.bottom.self
    pack .play.middle.bottom.self
    frame .play.left
    frame .play.right
    frame .play.left.lho
    frame .play.right.rho
    gset mframe(self) .play.middle.bottom.self
    gset mframe(pard) .play.middle.top.pard
    gset mframe(lho) .play.left.lho
    gset mframe(rho) .play.right.rho
    pack .play.left .play.middle .play.right -side left -fill x -expand yes
    pack .play.left.lho -side right -anchor e
    pack .play.right.rho -side left -anchor w
    pack .play.middle.top .play.middle.box .play.middle.bottom -fill x

    //create frames for displaying cards or bids
    frame .play.middle.box.lho
    frame .play.middle.box.rho
    frame .play.middle.box.pard
    frame .play.middle.box.self
    pack .play.middle.box.lho -side left -anchor w
    pack .play.middle.box.rho -side right -anchor e
    pack .play.middle.box.pard -side top -anchor n
    pack .play.middle.box.self -side bottom -anchor s

    //create four bogus buttons to put in .play.middle.box
    frame .play.middle.box.f
    frame .play.middle.box.f.s
    frame .play.middle.box.f.h
    frame .play.middle.box.f.d
    frame .play.middle.box.f.c
    refont [eval "button .play.middle.box.f.s.bogus $buttoncardoptions -state disabled"] cardfont
    refont [eval "button .play.middle.box.f.h.bogus $buttoncardoptions -state disabled"] cardfont
    refont [eval "button .play.middle.box.f.d.bogus $buttoncardoptions -state disabled"] cardfont
    refont [eval "button .play.middle.box.f.c.bogus $buttoncardoptions -state disabled"] cardfont
    pack .play.middle.box.f.s.bogus
    pack .play.middle.box.f.h.bogus
    pack .play.middle.box.f.d.bogus
    pack .play.middle.box.f.c.bogus
    eval "pack .play.middle.box.f.s .play.middle.box.f.h .play.middle.box.f.d \
	    .play.middle.box.f.c -side top -anchor w $framesuitoptions"
    pack .play.middle.box.f -side left -anchor w
}
#endif

#if 0
fulldeal AKQJT98765432 {} {} {} \
    {} AKQJT98765432 {} {} \
    {} {} AKQJT98765432 {} \
    {} {} {} AKQJT98765432
#endif

// if the next line is giving you trouble, replace it with: set x [set y 0]
set x [expr ![catch {regexp -nocase "Apr 1 " [exec date]} y]]
if !$x {set y 0}
if [expr $x && $y] {
 fulldeal AKQJ AKQJ AKQJ AK T98 T98 T98 QJT9 765 765 765 876 432 432 432 5432
 showbid self 8 n
} else {
 fulldeal AKQ AKQ AKQ AKQJ JT9 JT9 JT9 T987 876 876 876 6543 5432 5432 5432 2
 showbid self 7 n
}

#ifndef TEXT
// If the command line exists, focus it.  Other focus the text line.
proc focus_cmdline {} {
    global hideCommandLine_
    catch {
	focus .cmd
	if $hideCommandLine_ {
	    focus .cmd.talk
	} else {
	    focus .cmd.cmdline
	}
    }
}

//the talk window
//toplevel .talk -relief ridge -borderwidth 3
frame .talk -relief ridge -borderwidth 3
scrollbar .talk.scroll -command ".talk.text yview"
gset talktext [text .talk.text -wrap word -relief raised -yscrollcommand ".talk.scroll set" -width 300 -height 100 -font $talkfont]
refont .talk.text talkfont
pack .talk.scroll -side right -fill y
pack .talk.text -side left
bind .talk.text <Configure> {.talk.text yview -pickplace end}
bind .talk.text <FocusIn> focus_cmdline

//the debug window
//toplevel .debug
frame .debug -relief ridge -borderwidth 3
gset debugtext [text .debug.text -relief raised -yscrollcommand ".debug.scroll set" -width 300 -height 10]
scrollbar .debug.scroll -command ".debug.text yview"
pack .debug.scroll -side right -fill y
pack .debug.text -side left


//the command line and talk line
frame .cmd
frame .cmd.f
refont [label .cmd.f.labelt -font $cmdlinelabelfont -text "Talk:"] cmdlinelabelfont
refont [label .cmd.f.labelc -font $cmdlinelabelfont -text "Command:"] cmdlinelabelfont
pack .cmd.f.labelc .cmd.f.labelt -side top -anchor e
refont [entry .cmd.cmdline -font $cmdlinefont -relief sunken -bd 2 -textvariable cmd] cmdlinefont
refont [entry .cmd.talk -font $cmdlinefont -relief sunken -bd 2 -textvariable talk] cmdlinefont
pack .cmd.f -side left
pack .cmd.cmdline .cmd.talk -fill x -side top -expand yes

//the auction
frame .auction
frame .auction.bb
frame .auction.bb.0
frame .auction.bb.1
frame .auction.bb.2


// called when an auction button is pressed (e.g. the 7N button)
proc auctionbbcommand {what} {
    global alert redalert

    command $what
    if $alert {command alert}
    if $redalert {command redalert}
    set alert 0
    set redalert 0
}

// the next three procs are for making the auction buttons (1c...7n, etc)

proc auctionbb {w {what same}} {
    global auctionbbfont
    if {$what == "same"} {set what $w}
    refont [button .auction.bb.1.$w -text $what \
	    -command "auctionbbcommand $what" \
	    -font $auctionbbfont -relief flat -padx 1] auctionbbfont
}

proc auctionbb2 {w {what same}} {
    global auctionbbfont
    if {$what == "same"} {set what $w}
    refont [button .auction.bb.2.$w -text $what \
	    -command "auctionbbcommand $what" \
	    -font $auctionbbfont -relief flat -padx 1] auctionbbfont
}

proc auctionbb0 {w {what same}} {
    global auctionbbfont
    if {$what == "same"} {set what $w}
    refont [button .auction.bb.0.$w -text $what \
	    -command "auctionbbcommand $what" \
	    -font $auctionbbfont -relief flat] auctionbbfont
}

auctionbb0 pass Pass
auctionbb 1C  
auctionbb 1D  
auctionbb 1H  
auctionbb 1S  
auctionbb 1N  
auctionbb 2C  
auctionbb 2D  
auctionbb 2H  
auctionbb 2S  
auctionbb 2N  
auctionbb 3C  
auctionbb 3D  
auctionbb 3H  
auctionbb 3S  
auctionbb 3N  
auctionbb 4C  
auctionbb 4D  
auctionbb 4H  
auctionbb 4S  
auctionbb 4N  
auctionbb2 5C  
auctionbb2 5D  
auctionbb2 5H  
auctionbb2 5S  
auctionbb2 5N  
auctionbb2 6C  
auctionbb2 6D  
auctionbb2 6H  
auctionbb2 6S  
auctionbb2 6N  
auctionbb2 7C  
auctionbb2 7D  
auctionbb2 7H  
auctionbb2 7S  
auctionbb2 7N  
auctionbb0 x   Double
auctionbb0 xx  Redouble

refont [checkbutton .auction.bb.0.alert -text "Alert" -variable alert \
	-command {set redalert 0} -font $auctionbbfont \
	-relief flat] auctionbbfont
refont [checkbutton .auction.bb.0.redalert -text "Red Alert" \
	-variable redalert -command {set alert 0} \
	-font $auctionbbfont -relief flat] auctionbbfont

pack .auction.bb.0.alert .auction.bb.0.pass .auction.bb.0.x .auction.bb.0.xx .auction.bb.0.redalert -side left
pack .auction.bb.1.1C .auction.bb.1.1D .auction.bb.1.1H .auction.bb.1.1S .auction.bb.1.1N .auction.bb.1.2C .auction.bb.1.2D .auction.bb.1.2H .auction.bb.1.2S .auction.bb.1.2N .auction.bb.1.3C .auction.bb.1.3D .auction.bb.1.3H .auction.bb.1.3S .auction.bb.1.3N .auction.bb.1.4C .auction.bb.1.4D .auction.bb.1.4H .auction.bb.1.4S .auction.bb.1.4N -side left
pack .auction.bb.2.5C .auction.bb.2.5D .auction.bb.2.5H .auction.bb.2.5S .auction.bb.2.5N .auction.bb.2.6C .auction.bb.2.6D .auction.bb.2.6H .auction.bb.2.6S .auction.bb.2.6N .auction.bb.2.7C .auction.bb.2.7D .auction.bb.2.7H .auction.bb.2.7S .auction.bb.2.7N -side left
pack .auction.bb.0 .auction.bb.1 .auction.bb.2 -side top

refont [label .auction.l -font $auctionlabelfont -text $auctionlabel] auctionlabelfont
frame .auction.r
frame .auction.r.0
frame .auction.r.1
frame .auction.r.2
frame .auction.r.3
refont [label .auction.r.0.name -font $namefont -textvariable playername(lho) -width $auctionnamewidth -padx 1] namefont
refont [label .auction.r.1.name -font $namefont -textvariable playername(pard) -width $auctionnamewidth -padx 1] namefont
refont [label .auction.r.2.name -font $namefont -textvariable playername(rho) -width $auctionnamewidth -padx 1] namefont
refont [label .auction.r.3.name -font $namefont -textvariable playername(self) -width $auctionnamewidth -padx 1] namefont

pack .auction.r.0 .auction.r.1 .auction.r.2 .auction.r.3 -side left -anchor n
pack .auction.l .auction.r -side left -anchor n

pack .auction.r.0.name
pack .auction.r.1.name
pack .auction.r.2.name
pack .auction.r.3.name

// OK, here are the basic components
// pack .menu -side top -fill x
pack .stat -side top -fill x
pack .infoline -side top -fill x
pack .play -side top -expand no -fill both
//pack .auction -side top -fill both
#if DEBUG
pack .debug -side bottom -fill x
#endif
pack .cmd -side bottom -fill x
pack .talk -side top -fill both -expand yes

prop_on

//.talk.text insert end "Hello world in the talk window"


/////////////////////////////////////////////////////////////////////////////
// bindings---less copious than before because Tk defaults to emacs-like now
/////////////////////////////////////////////////////////////////////////////

proc typedcommand {cmd} {
    if {$cmd == ""} {command {inullcommand c}} {command $cmd}
}

proc typedtalk {talk} {
    if {$talk == ""} {command {inullcommand t}} {talk $talk}
}

proc bindsetup {w tabto returnscript} {
//  puts "bindsetup $w $tabto \{$returnscript\}"
    bind $w <Any-Enter> "focus %W"
    if {$tabto == ".cmd.cmdline"} {
	bind $w <KeyPress-Tab> "focus_cmdline; break"
	bind $w <Control-KeyPress-i> "focus_cmdline; break"
    } else {
	bind $w <KeyPress-Tab> "focus $tabto; break"
	bind $w <Control-KeyPress-i> "focus $tabto; break"
    }
    bind $w <KeyPress-Return> $returnscript
    return $w
}

bindsetup .cmd.cmdline .cmd.talk \
	{global cmd; if {$cmd == ""} {typedcommand $cmd} else {typedcommand $cmd; .cmd.cmdline delete 0 end}}

bindsetup .cmd.talk .cmd.cmdline \
	{global talk; if {$talk == ""} {typedtalk $talk} else {typedtalk $talk; .cmd.talk delete 0 end}}

focus_cmdline

#endif


/////////////////////////////////////////////////////////////////////////////
// Code to handle display of previous trick in the status bar
// (applicable to both TUI and GUI)
/////////////////////////////////////////////////////////////////////////////

gset previous_trick_index 0
gset previous_trick {}

proc reset_previous_trick {{index -999}} {
    global previous_trick previous_trick_index

    if {$index == -999 || $index == $previous_trick_index} {
	set previous_trick {}
    }
}

proc set_previous_trick {s {erase 1}} {
    global previous_trick previous_trick_index

    set previous_trick $s
    incr previous_trick_index

    // after 10 seconds, if same string is sitting there, erase it
    if $erase {after 10000 "reset_previous_trick $previous_trick_index"}
}

/////////////////////////////////////////////////////////////////////////////

#ifdef TEXT
gset oldpov S
gset oldseated 0

proc textseated {{seated -1} {pov S}} {
    global auctionx auctiony showingauction oldseated oldpov

    if {$seated == -1} {set seated $oldseated; set pov $oldpov}
    set oldseated $seated
    set oldpov $pov
    if !$showingauction return

    anchor "$auctionx $auctiony"
    down_and_anchor
    right 1
    if $seated {
	str "LHO Par RHO you"
    } else {
	if {$pov == "S"} {
	    str "(W) (N) (E) (S)"
	} elseif {$pov == "N"} {
	    str "(E) (S) (W) (N)"
	} elseif {$pov == "E"} {
	    str "(S) (W) (N) (E)"
	} elseif {$pov == "W"} {
	    str "(N) (E) (S) (W)"
	}
    }
}
#endif

// get rid of previous bidding; leave names and .auction.l alone
proc newauction {} {
#ifdef TEXT
    showauction 1
#else
    for {set i 0} {$i < 4} {incr i} {
	foreach child [winfo children .auction.r.$i] {
	    if ![regexp name $child] {catch {destroy $child}}
	}
    }
#endif
}

#ifdef TEXT
////////////////////////////////////////////////////////////////////////////
// Code for drawing the information displayed in the upper left and upper right
// corners of the textual UI---who dealt, the vulnerability, the contract, etc.
////////////////////////////////////////////////////////////////////////////

// these variables aren't used and should be removed
set statusline {}
set infoline {}

gset leftwidth 14
gset rightwidth 30
gset rightpos 50

proc strinfield {s x y width} {
    anchor "$x $y"
    clearrect $width 1
    if {[string length $s] > $width} \
	    {set s [string range $s 0 [expr $width - 1]]}
    str $s
}

strinfield $floater_version 0 0 15

// e.g. "Hosting" or "Connected"
proc connstat {{s {}}} {
    global leftwidth
    strinfield $s 0 1 $leftwidth 
}

// e.g. 22Oct96IMPS11
proc displayhandname {{s {}}} {
    global leftwidth
    strinfield $s 0 2 $leftwidth
}

proc statushandvul {{s {}}} {
    global leftwidth
    strinfield $s 0 3 $leftwidth
}

proc statushanddlr {{s {}}} {
    global leftwidth
    strinfield $s 0 4 $leftwidth
}

proc statuscontract {{s {}}} {
    global rightpos rightwidth
    strinfield $s $rightpos 0 $rightwidth
}

proc statustolead {{s {}}} {
    global rightpos rightwidth
    strinfield $s $rightpos 1 $rightwidth
}

proc displaytrickswon {{s {}}} {
    global rightpos rightwidth
    strinfield $s $rightpos 2 $rightwidth
}

// claim and result could probably share a line
proc statusclaim {{s {}}} {
    global rightpos rightwidth
    strinfield $s $rightpos 3 $rightwidth
}

proc statusresult {{s {}}} {
    global rightpos rightwidth
    strinfield $s $rightpos 4 $rightwidth
}

// break it up (at semicolons) onto multiple lines 
proc statusscore {{s {}}} {
    global leftwidth
    
    set x 0
    set y 5
    
    if {$s == ""} {set s " ; ; ; ; "} // clear 5 lines

    while {[regexp {([^;]*); (.*)} $s whole t s]} {
	strinfield $t $x $y $leftwidth
	incr y
    }
    strinfield $s $x $y $leftwidth
}
#endif

#ifdef TEXT
gset oldntalklines 0
gset scrolllock 0
#ifdef DEBUG
gset previoustalktop -1
#endif

proc drawtalkregion {{must_redraw 0}} {
    global talklines dtalklines talktop talklineattop talkbottom oldntalklines
    global scrolllock ntalklines
    
    draw_on_current_display +

    set talksize [expr $talkbottom - $talktop + 1]

    if {($dtalklines >= $ntalklines) || ($ntalklines < $talksize)} {
	set dtalklines $ntalklines
	set scrolllock 0
    }

    set want_to_redraw \
	   [expr ($dtalklines - $talklineattop) > $talksize]
    if {$must_redraw || ($want_to_redraw && !$scrolllock)} {
	// redraw everything
	set y $talktop
	set i [set talklineattop [expr $dtalklines - $talksize]]
	if {$i < 0} {
	    if $scrolllock {set dtalklines $talksize}
	    set i 0
	}
	for {set talklineattop $i} \
	    {($y <= $talkbottom) && ($i < $dtalklines) && ($i < $ntalklines)} \
	    {incr i; incr y} {
		drawtalkline $y $talklines($i)
	}
	
	// if we displayed everything, turn off scroll lock
	if {$i == $ntalklines} {set scrolllock 0}
    } elseif !$scrolllock {
	// we are not scrolling, but may be able to fill in some lines
	for {set y $talktop; set i $talklineattop} \
		{$y <= $talkbottom && $i < $dtalklines} \
		{incr i; incr y} {
	    if {$i >= $oldntalklines} {drawtalkline $y $talklines($i)}
	}
    }
    set oldntalklines $ntalklines
    reset_cursor_position
    draw_on_current_display -
}

proc talkscroll {n} {
    global scrolllock dtalklines

    incr dtalklines $n
    set scrolllock 1
    drawtalkregion 1
}

proc turn_off_scrolllock {} {
    talkscroll 1000000
}

proc talkregion {top bottom} {
    global talktop talkbottom talklineattop scrolllock

    set talktop $top
    set talkbottom $bottom
    drawtalkregion 1
}

proc drawtalkline {y s} {
    anchor "0 $y"
    str "$s\n"
}
#endif

#ifndef TEXT
proc turn_off_scrolllock {} {}
#endif

proc debugmsg {s} {
    global debugprinting floater_silent

    set old $debugprinting
    set debugprinting 1
    talkmsg $s
    set debugprinting $old
    if $floater_silent {puts $s}
}

/////////////////////////////////////////////////////////////////////////////
// changing to the watch cursor and back again
/////////////////////////////////////////////////////////////////////////////

proc setcursor {cursor w} {
#ifdef TEXT
#else
    if {$w == ".menu" || $w == ".#menu"} return 
    global oldcursor

    set oldcursor($w) [lindex [$w configure -cursor] 4]
    $w configure -cursor $cursor
    foreach child [winfo children $w] {setcursor $cursor $child}
#endif
}

proc unsetcursor {w} {
#ifdef TEXT
#else
    global oldcursor

    if [info exists oldcursor($w)] {
	catch {
	    $w configure -cursor $oldcursor($w)
	    foreach child [winfo children $w] {unsetcursor $child}
	}
    }
#endif
}

proc patientcursor {} {
    global cursorlevel
    
    if {[incr cursorlevel] == 1} {setcursor watch .}
}

proc normalcursor {} {
    global cursorlevel
    
    if {[incr cursorlevel -1] == 0} {unsetcursor .}
}
set cursorlevel 0
	
#ifndef TEXT
// configure all the widgets that have w as ancestor, and w itself
proc configall {w c} {
    eval "$w configure $c"
    foreach child [winfo children $w] {configall $child $c}
}
#endif

/////////////////////////////////////////////////////////////////////////////
// timers, periodic things
/////////////////////////////////////////////////////////////////////////////

// if DEBUG is defined, timeouts are set outrageously high to accomodate
// running many processes on our wimpy workstation

// in seconds, how long to wait before assuming a table is dead
#ifdef DEBUG
tryset tabletimeout 30000
#else
tryset tabletimeout 600
#endif

// in seconds, how often the tablehost should reannounce his table's existence
tryset tablereannounce 90


// receiveiamalivelist and sendiamalivelist are multisets implemented
// as unordered lists and really only used as sets, not multisets

set receiveiamalivelist {}
set sendiamalivelist {}

// in ms, how often to send "I'm alive" message to neighbors
tryset sendiamaliveinterval 40000

// in ms, how often to check that neighbors have sent me something lately
tryset receiveiamaliveinterval 20000

// in seconds, at what point do we assume our neighbor is dead?
#ifdef DEBUG
tryset iamalivetimeout 15000
#else
tryset iamalivetimeout 450
#endif

proc shouldreceiveiamalive {conn} {
    global receiveiamalivelist

    set receiveiamalivelist [linsert $receiveiamalivelist 0 $conn]
}

proc shouldnotreceiveiamalive {conn} {
    global receiveiamalivelist

    catch {
	set i [lsearch $receiveiamalivelist $conn]
	set receiveiamalivelist [lreplace $receiveiamalivelist $i $i]
    }
}

proc shouldsendiamalive {conn} {
    global sendiamalivelist

    set sendiamalivelist [linsert $sendiamalivelist 0 $conn]
}

proc shouldnotsendiamalive {conn} {
    global sendiamalivelist

    catch {
	set i [lsearch $sendiamalivelist $conn]
	set sendiamalivelist [lreplace $sendiamalivelist $i $i]
    }
}

proc sendiamalives {} {
    global sendiamalivelist sendiamaliveinterval

    after $sendiamaliveinterval sendiamalives
    foreach conn $sendiamalivelist {
	debugmsg "Sending iamalive to $conn"
	catch {FloaterSend $conn *alive*}
    }
}

proc checkreceiveiamalive {conn} {
    global iamalivetimeout timeofmostrecent floaterclock

//  puts "checkr. $conn"
    catch {
	debugmsg "seconds since most recent msg on $conn: [expr ($floaterclock - $timeofmostrecent($conn))]"
	if [expr ($floaterclock - $timeofmostrecent($conn)) > $iamalivetimeout] \
		{floatertimeout $conn}
    }
}

proc checkreceiveiamalives {} {
    global receiveiamalivelist receiveiamaliveinterval

    after $receiveiamaliveinterval checkreceiveiamalives
    foreach conn $receiveiamalivelist { checkreceiveiamalive $conn }
}

sendiamalives
checkreceiveiamalives

// MyTurnTimer -- the purpose of which is to refresh the display of
// the auction once every N seconds if it is my turn to bid and I
// haven't bid yet.  This is an attempt to combat the mysterious bug
// whereby the auction sometimes disappears/fails to appear for no reason,
// perhaps due to a packer bug in Tk.

gset MyTurnTimer -99
tryset MyTurnTimerCountdown 20
proc startMyTurnTimer {} {
    global MyTurnTimerCountdown MyTurnTimer
    set MyTurnTimer $MyTurnTimerCountdown
}    

proc MyTurnTimerRing {} {
    global showingauction
    if $showingauction {
	showauction 0
	showauction 1
	startMyTurnTimer
    }
}

proc stopMyTurnTimer {} {
    global MyTurnTimer
    set MyTurnTimer -99
}

// floaterclock

proc floaterclockbump {} {
    global floaterclock MyTurnTimer

    incr floaterclock
    if {$MyTurnTimer > 0} {if {[incr MyTurnTimer -1] == 0} MyTurnTimerRing}
    after 1000 floaterclockbump
    // every few seconds, issue null command to get tasks() called, etc.
    // (this is a hack and probably should be done via idletasks)
    if {[expr $floaterclock % 3] == 0} {command {}}
}

after 1000 floaterclockbump


proc countdown {x} {
    global $x

    if {[set $x] > 0} then "after 1000 \"countdown $x\"" else return
    incr $x -1
}

proc reset_rejoinnow {} {
    global rejoinclock rejoinclockincrement

    set rejoinclock 0
    set rejoinclockincrement 1
}

proc rejoinnow {} {
    global rejoinclock rejoinclockincrement

    if {$rejoinclock <= 0} then {
	if {$rejoinclockincrement < 1800} \
		{set rejoinclockincrement [expr 2 * $rejoinclockincrement]}
	set rejoinclock $rejoinclockincrement
	countdown rejoinclock
	return 1
    } else {return 0}
}

proc reset_find_rho {} {
    global rhoclock rhoclockincrement

    set rhoclock 0
    set rhoclockincrement 1
}

proc findrhonow {} {
    global rhoclock rhoclockincrement

    if {$rhoclock <= 0} then {
	if {$rhoclockincrement < 1800} \
		{set rhoclockincrement [expr 2 * $rhoclockincrement]}
	set rhoclock $rhoclockincrement
	countdown rhoclock
	return 1
    } else {return 0}
}

reset_find_rho
reset_rejoinnow

// whether we are currently waiting on an autodeal timer
gset autodealing 0

proc autonewdeal {} {
    global autonewdeal_seconds autodealing

    if $autodealing return
    if {$autonewdeal_seconds >= 0} {
	set autodealing 1
	after [expr 1000 * $autonewdeal_seconds] {
	    global autodealing
	    
	    if $autodealing {
		set autodealing 0
		if {$autonewdeal_seconds >= 0} {command autodeal_now}
	    } else {
#ifdef DEBUG
#ifndef TEXT
		puts stderr "autodeal not performed"
#endif
#endif
	    }
	}
    }
}

proc updateloc {} {
    global updateloc_seconds

    after [expr 1000 * $updateloc_seconds] updateloc
    catch {command iupdatelocation}
}

tryset updateloc_seconds 300
updateloc

///////////////////////////////////////////////////////////////////////////////
// Deferring callbacks into Floater's C code because the C code isn't reentrant
///////////////////////////////////////////////////////////////////////////////

// initially zero, but set by the C code---see proc defer below---when
//  it doesn't want reentry
gset should_defer 0

proc command args {
    global should_defer

    if $should_defer {deferpush "commandn $args"} else {eval "commandn $args"}
}

#if 0
proc floateralive {conn} {
    global timeofmostrecent floaterclock

    debugmsg "Received iamalive from $conn"
    set timeofmostrecent($conn) $floaterclock // redundant, but can't hurt
}
#endif

proc floaterreceive {msg conn} {
    global should_defer timeofmostrecent floaterclock

    set timeofmostrecent($conn) $floaterclock
    // if {$msg == "*alive*"} { floateralive $conn; return }
    if {$msg == "*alive*"} return

    if $should_defer {
	deferpush "floaterreceiven {$msg} {$conn}"
    } else {
	floaterreceiven $msg $conn
    }
}

proc talk args {
    global should_defer

    if $should_defer {deferpush "talkn $args"} else {eval "talkn $args"}
}

proc FloaterClose args {
    global should_defer

    if $should_defer {deferpush "FloaterClosen $args"} \
	    else {eval "FloaterClosen $args"}
}

#if 0
proc requestresult args {
    global should_defer

    if $should_defer {deferpush "requestresultn $args"} \
	    else {eval "requestresultn $args"}
}
#endif

proc floatertimeout args {
    global should_defer

    if $should_defer {deferpush "floatertimeoutn $args"} \
	    else {eval "floatertimeoutn $args"}
}

/////////////////////////////////////////////////////////////////////////////
// implementation of a queue for deferred commands
/////////////////////////////////////////////////////////////////////////////

// Modifies the variable should_defer by adding n to it.
// If should_defer becomes 0 as a result, do the queue of deferred commands.
proc defer {n} {
    global should_defer

    if {[incr should_defer $n] == 0} {
	while {![deferempty]} {eval [deferpop]}
    }
}

gset deferqueuelo 0
gset deferqueuehi 0

proc deferempty {} {
    global deferqueuehi deferqueuelo

    return [expr $deferqueuelo == $deferqueuehi]
}

proc deferpush {s} {
    global deferqueue deferqueuehi
    
    set deferqueue($deferqueuehi) $s
    incr deferqueuehi
#ifdef DEBUG
    debugmsg "Deferring $s"
#endif
}

proc deferpop {} {
    global deferqueue deferqueuelo
    
    set temp $deferqueue($deferqueuelo)
    unset deferqueue($deferqueuelo)
    incr deferqueuelo
#ifdef DEBUG
    debugmsg "Deferpop $temp"
#endif
    return $temp
}

/////////////////////////////////////////////////////////////////////////////
// Execute commands taken from a file
/////////////////////////////////////////////////////////////////////////////

set executing_index 0

proc Floater_execute {file} {
    global executing_index executing_command
    if {[set n [gets $file s]] >= 0} {
	if {$n > 0} {
	    deferpush "show_executing [incr executing_index]; Floater_execute $file"
	    set executing_command($executing_index) $s
	    return
	}
    }
    catch {close $file}
}    

proc show_executing {n} {
    global executing_command

    talkmsg "Execute: $executing_command($n)"
    commandn $executing_command($n)
    unset executing_command($n)
}
/////////////////////////////////////////////////////////////////////////////
// Convention cards
/////////////////////////////////////////////////////////////////////////////

proc untabify {s} {
    if [regexp {([^	]*)	(.*)} $s whole left right] {
	set i [string length $left]
	while 1 {
	    set right " $right"
	    incr i
	    if [expr $i % 8 == 0] {return [untabify $left$right]}
	}
    } else {return $s}
}

proc truncate {s {n 80}} {
    if {[string length $s] > $n} {
	return [string range $s 0 [expr $n - 1]]
    } else {
	return $s
    }
}

proc unbraceclean {s} {
    regsub -all {\\(\[|\]|\{|\})} $s {\1} x
    return $x
}

proc beginnewcc {direction} {
    global newcc newccline newccignoring

    set newccline 0
    set newccignoring 0
    set newcc $direction
}

proc addnewcc {s {bracecleaned 1}} {
    global newcc newccline cc newccignoring

    set s [untabify [truncate $s]]
    if $bracecleaned {set s [unbraceclean $s]}
    if {$newccline == 40} {set newccignoring 1; return}
    set cc($newcc,[incr newccline]) $s
}

proc endnewcc {} {
    global newcc newccline newccignoring cclines

    set cclines($newcc) $newccline
    // The cc is stored in cc($newcc,1) through cc($newcc,$cclines($newcc))
    if $newccignoring {
	return "Warning: Ignored lines beyond the first 40"
    } else {
	return ""
    }
}

// String together all the lines of the cc for the named direction, using
// tabs as glue (because tabs are not allowed in a cc).
proc ccstr {direction} {
    global cc cclines

    set s ""
    catch {
	if {$cclines($direction) < 1} {return ""}
	set s $cc($direction,1)
	for {set i 2} {$i <= $cclines($direction)} {incr i} {
	    set s "$s\t$cc($direction,$i)"
	}
    }
    return $s
}

gset lastrange "" // for trivial memoization
proc inrange {n range} {
    global lastrange lastrangelow lastrangehigh // for trivial memoization

    if {$range != $lastrange} {
	set lastrange $range
	if [regexp {^([0-9]+)-([0-9]+)$} $range x lastrangelow lastrangehigh] {
	    // everything's all set
	} elseif [regexp {^([0-9]+)$} $range lastrangelow] {
	    set lastrangehigh $lastrangelow
	} elseif [regexp {^([0-9]+)-$} $range x lastrangelow] {
	    set lastrangehigh 1000000
	} elseif [regexp {^-([0-9]+)$} $range x lastrangehigh] {
	    set lastrangelow -1000000
	} else {error "Invalid range: $range"}
    }
    expr ($n >= $lastrangelow) && ($n <= $lastrangehigh)
}

proc ccdump {direction {range 1-}} {
    global cc cclines

    for {set i 1} {$i <= $cclines($direction)} {incr i} {
	if [inrange $i $range] {
	    talkmsg $cc($direction,$i)
	}
    }
}

proc ccsave {file direction} {
    global cc cclines

    for {set i 1} {$i <= $cclines($direction)} {incr i} {
	puts $file $cc($direction,$i)
    }
    close $file
}

proc getccline {direction line} {
    global cc cclines

    if ![info exists cclines($direction)] {return ""}
    if {$line <= $cclines($direction)} {
	return $cc($direction,$line)
    } else {
	return ""
    }
}

/////////////////////////////////////////////////////////////////////////////
// Hack for printing a bunch of lines in reverse order (used for EW results)
/////////////////////////////////////////////////////////////////////////////

// Note that each reverse_init call must be matched by a reverse_done,
// with no reverse_init calls in between.
proc reverse_init {} {
    global reverse_n

    set reverse_n 0
}

proc reverse_print {s} {
    global reverse_n reverse_lines

    set reverse_lines($reverse_n) $s
    incr reverse_n
}

proc reverse_done {} {
    global reverse_n reverse_lines

    while {[incr reverse_n -1] >= 0} {
	talkmsg $reverse_lines($reverse_n)
	unset reverse_lines($reverse_n)
    }
}

/////////////////////////////////////////////////////////////////////////////
proc Floater_login {} {
    global loginname loginpassword newbie

    toplevel .login

    frame .login.left
    frame .login.right
    frame .login.bottom

    button .login.bottom.cancel -text "Cancel" \
	-command {set loginname ""; set loginpassword ""; destroy .login}
    button .login.bottom.clear -text "Clear" \
	-command {set loginname ""; set loginpassword ""; focus .login.right.n}
    button .login.bottom.ok -text "OK" \
	-command {destroy .login}

    proc newbietr {name el op} {
	global pw_or_email newbie

	if $newbie {set pw_or_email "Email address: "} \
		{set pw_or_email "Password: "}
    }

    checkbutton .login.new -text "New User" -variable newbie
    trace variable newbie w newbietr
    if [info exists newbie] {set newbie $newbie} {set newbie 0}

    label .login.left.n -text "Name: "
    label .login.left.p -textvariable pw_or_email -width 13

    entry .login.right.n -bd 2 -relief sunken -textvariable loginname
    entry .login.right.p -bd 2 -relief sunken -textvariable loginpassword

    pack .login.bottom.cancel .login.bottom.clear .login.bottom.ok \
	-side left -expand yes -fill x -padx 3m -pady 2m
    pack .login.left.n .login.left.p
    pack .login.right.n .login.right.p
    pack .login.bottom -side bottom
    pack .login.new -side bottom -pady 2m
    pack .login.left -side left -fill x -expand yes
    pack .login.right .login.right -side right -fill x -expand yes
    wm title .login "Floater login"

    bindsetup .login.right.n .login.right.p {focus .login.right.p}
    bindsetup .login.right.p .login.right.n {destroy .login}
    bind .login.right.n \\ {set loginname ""}

    grab set .login
    tkwait window .login
    trace vdelete newbie w newbietr
    set loginname [string trim $loginname]
    catch focus_cmdline
    if $newbie {return "N$loginname\\$loginpassword"} \
	    {return "O$loginname\\$loginpassword"}
}

proc Floater_changepw {} {
    global changepwname oldpassword newpassword

    toplevel .changepw

    frame .changepw.left
    frame .changepw.right
    frame .changepw.bottom


    button .changepw.bottom.cancel -text "Cancel" \
	-command {set changepwname ""; set oldpassword ""; \
	set newpassword ""; destroy .changepw}
    button .changepw.bottom.clear -text "Clear" \
	-command {set changepwname ""; set oldpassword ""; \
	set newpassword ""; focus .changepw.right.n}
    button .changepw.bottom.ok -text "OK" \
	-command {destroy .changepw}

    label .changepw.left.n -text "Name: "
    label .changepw.left.o -text "Old password: "
    label .changepw.left.p -text "New password: "

    entry .changepw.right.n -bd 2 -relief sunken -textvariable changepwname
    entry .changepw.right.o -bd 2 -relief sunken -textvariable oldpassword
    entry .changepw.right.p -bd 2 -relief sunken -textvariable newpassword

    pack .changepw.bottom.cancel .changepw.bottom.clear .changepw.bottom.ok \
	-side left -expand yes -fill x -padx 3m -pady 2m
    pack .changepw.left.n .changepw.left.o .changepw.left.p
    pack .changepw.right.n .changepw.right.o .changepw.right.p
    pack .changepw.bottom -side bottom
    pack .changepw.left -side left -fill x -expand yes
    pack .changepw.right .changepw.right -side right -fill x -expand yes
    wm title .changepw "change password"

    bindsetup .changepw.right.n .changepw.right.o {focus .changepw.right.o}
    bindsetup .changepw.right.o .changepw.right.p {focus .changepw.right.p}
    bindsetup .changepw.right.p .changepw.right.n {destroy .changepw}
    bind .changepw.right.n \\ {set changepwname ""}

    grab set .changepw
    tkwait window .changepw
    catch {focus .cmd; focus .cmd.talk}
    return "$changepwname\\$oldpassword\\$newpassword"
}
