static char proto_rcsid[]="$Id: proto.c,v 1.1.1.1 1998/08/18 14:39:14 green Exp $";

/*----------------------------------------------------
 * proto.c Tom Green Mon Jan 31 10:43:10 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: proto.c,v $
 * Revision 1.1.1.1  1998/08/18 14:39:14  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.1.1.1  1997/04/10 15:10:35  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.3  1996/11/20 23:05:05  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.2  1995/05/29  18:09:02  nrl
 * More solaris stuff GAGGHH had to differentiate more cases of
 * solaris2.3 and solaris2.4 stuff
 *
 * Revision 3.1  1995/02/22  14:29:51  nrl
 * added "FREE" macro to make sure all freed pointers are NULL,
 * replaced all calls to free( ) with FREE.
 *
 * Revision 3.0  1994/03/07  04:15:13  green
 * 3.0 freeze
 *
 * Revision 1.1.1.1  1994/02/01  17:57:50  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/


#include <stdio.h>
#include <ctype.h>
#include <strings.h>

#define PROTOLEN 10000
#define BLANK ' '
#define TAB '\t'
#define NEWLINE '\n'
#define BUFFER_SIZE 256
#define TRUE 1
#define FALSE 0
#define retract(num) {input_index-=num; token_index-=num;}
#define NUMBER     1
#define IDENTIFIER 2
#define CHARACTER  3
#define STRING     4
#define RESSYM     5

typedef int token;                        /* token type definition */
char c;                                   /* used for nextchar() */
char *token_buffer;                       /* stores the next token lexeme */
char input_buffer[BUFFER_SIZE];           /* input is buffered */
int token_buffer_cnt   = 0;               /* size of token_buffer */
int state              = 0;               /* state of transition diagram */
int token_index        = 0;               /* index into the token_buffer */
int endptr             = BUFFER_SIZE;     /* last character in input_buffer */
int input_index        = BUFFER_SIZE+1;   /* index into the input_buffer */
int processing_comment = 0;               /* flag for ignoring comments */
int short_listing=0;

/**********************************************************
 * 
 * void add(c)
 * char c;
 * 
 * This procedure adds the character c to the dynamic 
 * token_buffer containing the lexeme of the next token.
 * 
 */
void add(c)
     char c;
{
  /* see if token_buffer is full */
  if ((token_index+1) >= (BUFFER_SIZE*token_buffer_cnt)) {
    token_buffer_cnt++;
    token_buffer = (char *)realloc(token_buffer, BUFFER_SIZE*token_buffer_cnt);
  }
  token_buffer[token_index++]=c;      /* add to end of token buffer */
}

/**********************************************************
 * 
 * int gettoken()
 * 
 * This function returns the value of the next token found
 * in the input_buffer and prints the token to stdout.
 *
 */
int gettoken()
{
  add(0);                                  /* terminate string in token_buffer */
  /*  fprintf (stdout,"%s\n",token_buffer);    /* display next token */
  token_index=0;                           /* reset token index */
  switch(state) {                          /* return token value depending on state */
  case 0 : case 15 : case 16 : case 17 : case 18 : case 19 : case 20 :  case 21 : 
    state = 0; return RESSYM;
  case 1 : state = 0; return NUMBER;
  case 2 : state = 0; return IDENTIFIER;
  case 5 :  case 9 :  case 10 : case 11 :
    state = 0; return CHARACTER;
  case 13: state = 0; return STRING;
  default : state = 0; fprintf (stderr,"unknown state\n");
  }
}

/**********************************************************
 * 
 * char nextchar()
 *
 * This function returns the value of the next
 * available character in the input_buffer.
 * 
 */
char nextchar()
{
  if (input_index>endptr) {                       /* past the end of the buffer? */
    input_index = 0;                              /* reset index */
    if (!fgets(input_buffer,BUFFER_SIZE-1,stdin)) /* read next buffer */
      return('\0');                                /* at end of file */
    
    endptr=strlen(input_buffer)-1;
  }
  return input_buffer[input_index++];       /* return next character indexed in buffer */
}

/**********************************************************
 * 
 * void fail()
 *  
 * This procedure is our error handler. Nothing fancy here;
 * just reports any found errors.
 *
 */
void fail()
{
  int i;
  /* see if we have a problem with a character */
  /* grab the whole character error if it exists on the same line */
  if (state==3 || state==5 || state==9 || state==10 || state==11) {
    for (i=input_index;input_buffer[i]!='\n'&&input_buffer[i]!='\''&&i<endptr;i++);
    if (input_buffer[i]=='\'') {
      for (;input_buffer[input_index]!='\'';input_index++) add(input_buffer[input_index]);
      add(input_buffer[input_index++]);
    }
  }
  add(0);                                   /* terminate our token_buffer */
#ifdef USELESS
  if (processing_comment)                   /* found end of file in comment */
    /*    fprintf (stderr,"cscan: ????? unexpected end of file\n");*/
    else
      /*    fprintf (stderr,"cscan: ????? token %s\n",token_buffer);*/
#endif
      state = 0;                                /* reset state */
  token_index = 0;                          /* reset token index */
}


/**********************************************************
 * 
 * token nexttoken()
 *
 * This function returns the value of the next token and
 * was implemented from a transition state diagram.
 * 
 */
token nexttoken()
{
  while (1) {                                /* loop until we get next token */
    if (!(c = nextchar())) {             /* we are out of data */
      if (state!=0 || processing_comment)    /* serious error on the part of user */
	fail();                              /* ended file in middle of a comment */
      return 0;                              /* signals end of file */
    }
    add(c);                                  /* go ahead and add to the token_buffer */
    switch (state) {                         /* depending on which state */
    case 0 :                                 /* looking for beginning of next token */
      if (c==BLANK || c==TAB || c==NEWLINE) {state = 0; token_index--;}  /* white space */
      else if (isdigit(c)) state = 1;        /* we've got a number */
      else if (isalpha(c)) state = 2;        /* we've got an identifier */
      else if (c=='\'') state = 3;           /* beginning of a character */
      else if (c=='"') state = 13;           /* beginning of a string */
      else if (c=='&') state = 15;           /* beginning of an operator */
      else if (c=='|') state = 16;           /* beginning of an operator */
      else if (c=='+') state = 17;           /* beginning of an operator */
      else if (c=='-') state = 18;           /* beginning of an operator */
      else if (c=='^') state = 19;           /* beginning of an operator */
      else if (c=='%') state = 19;           /* beginning of an operator */
      else if (c=='*') state = 19;           /* operator  or comment     */
      else if (c=='/') state = 22;           /* beginning of an operator */
      else if (c=='=') state = 19;           /* beginning of an operator */
      else if (c=='!') state = 19;           /* beginning of an operator */
      else if (c=='>') state = 20;           /* beginning of an operator */
      else if (c=='<') state = 21;           /* beginning of an operator */
      else if (c=='#') {        /* attempt to handle preprocessing stuff */
	while(c!=EOF && c!='\n') {
	  c=nextchar();
	  if(c=='\\')
	    c=nextchar();
	}
	fail();
      }
      else
	switch (c) {                         
	case '(' : case ')' : case ',' : case '.' : case ':' : case ';' : case '?' :
	case '[' : case ']' : case '{' : case '}' : case '~' :
	  return (gettoken());              /* we've got an operator */
	default : fail();                  /* unrecognized character */
	}
      break;
    case 1 :                                   
      if (isdigit(c)) state = 1;               /* get rest of number */
      else {retract(1); return (gettoken());}  /* not a digit, put back in input_buffer */
      break;
    case 2 :
      if (isalnum(c) || c=='_') state = 2;     /* get rest of identifier */
      else {retract(1); return (gettoken());}  /* put back in input_buffer unknown char */
      break;
    case 3 :                                   /* get rest of character */ 
      if (c=='\'') fail();
      else if (c=='\\') state = 4;             /* is next char a backslash? */
      else state = 5;                          /* look for normal character */
      break;
    case 4 :
      if (isdigit(c) && c!='8' && c!='9') state = 9;  /* we have an octal char */
      else if (c=='\'') state = 5;                    /* we have a single quote */
      else if (c=='\\') state = 5;                    /* we have a backslash */
      else if (c=='\"') state = 5;                    /* we have a double quote */
      else state = 5;                                 /* we have an escaped character */
      break;
    case 5 :
      if (c=='\'') return (gettoken());               /* look for closing quote */
      else {retract(1); fail();}                      /* didn't find a legal character */
      break;
    case 9 : 
      if (isdigit(c) && c!='8' && c!='9') state = 10; /* second digit in octal */
      else if (c=='\'') return (gettoken());          /* found 2-digit octal */
      else fail();                                    /* incorrect octal */
      break;
    case 10 : 
      if (isdigit(c) && c!='8' && c!='9') state = 11; /* third digit in octal */
      else if (c=='\'') return (gettoken());          /* found 3-digit octal */
      else fail();                                    /* incorrect octal */
      break;
    case 11 :
      if (c=='\'') return (gettoken());               /* valid octal char */
      else fail();                                    /* incorrect octal */
      break;
    case 13 :                                         /* get rest of string */
      if (c=='\\') state = 14;                        /* check for escaped return */
      else if (c=='"') return (gettoken());           /* found end of string */
      else state = 13;
      break;
    case 14 :                                       
      if (c=='\n') {token_index -= 2; state = 13;}    /* we have an escaped return */
      else state = 13;                                /* remove return char from token buffer */
      break;
    case 15 :
      if (c=='&') return (gettoken());                /* found &&     */
      else {retract(1); state = 19; break;}           /* check for &= */
    case 16 :
      if (c=='|') return (gettoken());                /* found ||     */
      else {retract(1); state = 19; break;}           /* check for |= */
    case 17 :
      if (c=='+') return (gettoken());                /* found ++     */
      else {retract(1); state = 19; break;}           /* check for += */
    case 18 :
      if (c=='-') return (gettoken());                /* found --     */
      else if (c=='>') return (gettoken());           /* found ->     */
      else {retract(1); state = 19; break;}           /* check for -= */
    case 19 :
      if (c=='=') return (gettoken());                /* found {operator}= */
      else {retract(1); return (gettoken());}         /* found {operator}  */
    case 20 :
      if (c=='>') state = 19;                         /* got >> so far */
      else {retract(1); state = 19;}                  /* got >  so far */
      break;
    case 21 :
      if (c=='<') state = 19;                         /* got << so far */
      else {retract(1); state = 19;}                  /* fot >  so far */
      break;
    case 22 :
      if (c=='*') state = 23;                         /* begin comment? */
      else {retract(1); state = 19;}                  /* check for /=   */
      break;
    case 23 :
      if (c=='*') state = 24;                         /* ? end comment   */
      else state = 23;                                /* ignore comments */
      break;
    case 24 : 
      if (c=='/') {token_index = 0; state = 0;}       /* end comment     */
      else {retract(1); state = 23;}                  /* ignore comments */
      break;
    }
  }
}

int ind;
int rightparen=0;

void main(argc,argv)
     int argc;
     char *argv[];
{
  int tokenval;
  int ii;
  int level=0;
  int state=0;
  char *list[PROTOLEN];
  void init(),printproto(),clear(),insert();
  
  if (argc>1) short_listing++;
  
  if (!short_listing)   printf("#if (sun || solaris || vax || __hpux)\n#define NO_PROTO\n#endif\n\n");
  init(list);
  while (tokenval=nexttoken()) {
    /*    printf("%d %s\n",tokenval,token_buffer);fflush(stdout);*/
    switch(tokenval) {
    case RESSYM:
      switch(token_buffer[0]) {
      case '{':
	if(level==0 && rightparen) {
	  printproto(list);
	}
	clear(list);
	level++;
	break;
      case '}':
	level--;
	clear(list);
	break;
      case ';':
	if(level==0) {
	  if(!rightparen || *list[ind-1]==')') {
	    clear(list);
	  }
	  else {
	    insert(list,token_buffer);
	  }
	}
	break;
      case ')':
	rightparen=1;
      default:
	if(level==0) {
	  insert(list,token_buffer);
	}
      }
      break;
    case IDENTIFIER:
      if(level==0) {
	insert(list,token_buffer);
      }
      break;
    }
  }
}

void printproto(list)
     char **list;
{
  int ii;
  int done;
  void find();
  
  if (!short_listing) printf("#ifdef NO_PROTO\n");
  for(done=ii=0;list[ii] && !done;ii++) {
    if(*list[ii]=='(') {
      if (!short_listing) printf("();\n");
      done=1;
    }
    else
      printf("%s ",list[ii]);
  }
  
  if (!short_listing)   printf("#else\n");
  for(done=ii=0;list[ii] && !done;ii++) {
    if(*list[ii]=='(') {
      printf("(");
      done=1;
    }
    else 
      printf("%s ",list[ii]);
  }
  for(done=0;list[ii] && !done;ii++) {
    if(*list[ii]==',')
      printf(", ");
    else if(*list[ii]==')') {
      done=1;
    }
    else {
      find(list,list[ii],ii);
    }
  }
  printf(");\n");
  if (!short_listing)   printf("#endif\n");
}

void find(list,str,ii)
     char **list;
     char *str;
     int ii;
{
  char buffer[128];
  int comma=0;
  
  buffer[0]=0;
  for(ii++;list[ii] && strcmp(list[ii],str);ii++);
  for(ii--;ii && strcmp(list[ii],")") && strcmp(list[ii],";");ii--)
    if(!strcmp(list[ii],","))
      comma++;
  
  
  for(ii++;strcmp(list[ii],str) && strcmp(list[ii],",") && strcmp(list[ii],"*");ii++) {
    if(!comma || (comma && strcmp(list[ii+1],",") && strcmp(list[ii+1],"["))) {
      strcat(buffer,list[ii]);
      strcat(buffer," ");
    }
  }
  
  for(;list[ii] && strcmp(list[ii],str);ii++);
  for(ii--;!strcmp(list[ii],"*");ii--);
  for(ii++;strcmp(list[ii],";") && strcmp(list[ii],",");ii++) {
    strcat(buffer,list[ii]);
  }
  printf("%s",buffer);
}

void insert(list,str)
     char **list;
     char *str;
{
  char *tmp;
  tmp=(char *)malloc(strlen(str)+1);
  strcpy(tmp,str);
  if(ind<PROTOLEN) {
    list[ind]=tmp;
    ind++;
  }
}

void init(list)
     char **list;
{
  int ii;
  for(ii=0;ii<PROTOLEN;ii++) {
    list[ii]=NULL;
  }
  rightparen=ind=0;
}

void clear(list)
     char **list;
{
  int ii;
  for(ii=0;ii<PROTOLEN;ii++) {
    if(list[ii])
      FREE(list[ii]);
    list[ii]=NULL;
  }
  rightparen=ind=0;
}

void foobar() 
{
  
}
