#!/bin/csh
#
#		convert.csh <image> <type>
#		<type> = ps | pdf | gif
#	Converts <image> and displays it; assumes <image> has
#	descriptive extension (eg image.gif)
#	

set TMP = ../tmp
#/opt/sfw/share/ghostscript/6.52/lib/gs_fonts.ps
#/opt/sfw/esp/share/ghostscript/7.05/lib/gs_fonts.ps
setenv GS_LIB /opt/sfw/share/ghostscript
setenv LD_LIBRARY_PATH /usr/openwin/lib:/usr/dt/lib:/usr/lib:/usr/ucblib:/opt/sfw/lib:/usr/local/lib

set path = ($path /opt/sfw/bin)

#---------Make all the logos----------------------------------------------
unalias rm
unalias cp

#
if ( ($#argv > 0) && (-e $1) ) then
   set type = "gif"
   if ($#argv > 1) then
      set type = $2
   endif
   set image = $TMP/$$.$type
#  convert -sharpen 75 $1 $image
   convert $1 $image
else
   echo "Content-type: text/html"
   echo ""
   echo "Convert error: Input file $1 not found"
   exit
endif

#-------------------------------------------------------------------------
if (! (-e $image) ) then
	echo "Content-type: text/html"
	echo ""
	echo "Convert error: Output file $image not found"
	exit
endif

#-------------------------------------------------------------------------
#	Show the image
if ($type == "ps") then
   echo "Content-type: application/postscript"
   echo ""
   cat $image
else
   if ($type == "pdf") then
      echo "Content-type: application/pdf"
      echo ""
      cat $image
   else
      if ($type == "gif") then
         echo "Content-type: image/gif"
         echo "" 
         cat $image
      else
         echo "Content-type: text/html"
         echo ""
         echo "Unrecognized image type: $type"
      endif
   endif
endif
rm $image
exit(0)
