######################################################################
# create wikis from templates

from Globals import HTMLFile, package_home
from OFS.Folder import Folder
from OFS.DTMLMethod import DTMLMethod
from Products.ZWiki.ZWikiPage import ZWikiPage
from AccessControl import getSecurityManager
from Defaults import DEFAULT_PAGE_TYPE
import os, re, string

# ZMI wiki creation form
manage_addZWikiWebForm = HTMLFile('dtml/zwikiWebAdd', globals())

######################################################################
# FUNCTION CATEGORY: wikiweb creation
######################################################################

def manage_addZWikiWeb(self, new_id, new_title='', wiki_type='zwikidotorg',
                       REQUEST=None, enter=0):
    """
    Create a new zwiki web of the specified type

    #>>> ZWiki.manage_addZWikiWeb('test')
    
    """
    if wiki_type in self.listFsWikis():
        self.addZWikiWebFromFs(new_id,new_title,wiki_type,REQUEST)
    elif wiki_type in self.listZodbWikis():
        self.addZWikiWebFromZodb(new_id,new_title,wiki_type,REQUEST)
    else:
        messageDialog('unknown wiki type')

    if REQUEST is not None:
        if enter:
            # can't see why this doesn't work after addZWikiWebFromFs
            #REQUEST.RESPONSE.redirect(getattr(self,new_id).absolute_url())
            REQUEST.RESPONSE.redirect(REQUEST['URL3']+'/'+new_id+'/')
        else:
            try: u=self.DestinationURL()
            except: u=REQUEST['URL1']
            REQUEST.RESPONSE.redirect(u+'/manage_main?update_menu=1')
    #why do this ?
    #else:
    #    return ''

def addZWikiWebFromZodb(self,new_id, new_title='', wiki_type='zwikidotorg',
                        REQUEST=None):
    """
    Create a new zwiki web by cloning the specified template
    in /Control_Panel/Products/ZWiki
    """
    # locate the specified wiki prototype
    # these are installed in /Control_Panel/Products/ZWiki
    prototype = self.getPhysicalRoot().Control_Panel.Products.ZWiki[wiki_type]

    # clone it
    self.manage_clone(prototype, new_id, REQUEST)
    wiki = getattr(self, new_id)
    wiki.manage_changeProperties(title=new_title)
    # could do stuff with ownership here
    # set it to low-privileged "nobody" by default ?


def addZWikiWebFromFs(self, new_id, title='', wiki_type='zwikidotorg',
                      REQUEST=None):
    """
    Create a new zwiki web from the specified template on the filesystem

    """
    ob = Folder()
    ob.id=str(new_id)
    ob.title=str(title)
    id = self._setObject(ob.id, ob)
    ob = getattr(self, id)
    p = package_home(globals()) + os.sep + 'wikis' + os.sep + wiki_type
    fnames = os.listdir(p)
    # hmm auto-cataloging is really slowing this down!
    for fname in fnames:
        if re.match(r'[Mm]akefile',fname): # I must be allowed my makefiles
            continue
        elif fname[-1] == '~':          # and just in case
            continue
        elif re.match(r'[A-Z]',fname[0]):
            f = open(p + os.sep + fname, 'r')
            _addZWikiPage(ob, fname, title='', file=f.read())
        elif re.match(r'[a-z]',fname[0]):
            f = open(p + os.sep + fname, 'r')
            _addDTMLMethod(ob, fname, title='', file=f.read())
        else:
            continue

def _addZWikiPage(self, id, title='', file=''):
    """
    >>> ZWiki.manage_addZWikiWeb('test')
    >>> zc['test'].RecentChanges.page_type
    'htmldtml'
    >>> zc['test'].RecentChanges.parents
    ['HelpPage']
    """
    id=str(id)
    title=str(title)
    # parse optional attributes
    # it's late - please do better
    m = re.match(r'(?si)(^#page_type:(.*?)\n)?(.*)',file)
    if m.group(2):
        page_type = string.strip(m.group(2))
    else:
        page_type = DEFAULT_PAGE_TYPE
    file = m.group(3)
    m = re.match(r'(?si)(^#parents:(.*?)\n)?(.*)',file)
    if m.group(2):
        parents = string.split(string.strip(m.group(2)),',')
    else:
        parents = []
    file = m.group(3)
    text = file

    #ob = makeZWikiPage(id, title, file)
    ob = ZWikiPage(source_string=text, __name__=id)
    ob.title = title
    ob.page_type = page_type
    ob.parents = parents

    username = getSecurityManager().getUser().getUserName()
    ob.manage_addLocalRoles(username, ['Owner'])
    # is that what we want ? how about what we do elsewhere
#    # 2.2-specific: the new page object is owned by the current
#    # authenticated user, if any; not desirable for executable content.
#    # Remove any such ownership so that the page will acquire it's
#    # owner from the parent folder.
#    ob._deleteOwnershipAfterAdd()
#    #XXX or _owner=UnownableOwner ?
    #ob.setSubOwner('both') #?
    self._setObject(id, ob)

#def _makeZWikiPage(id, title, file):
#    ob = ZWikiPage(source_string=file, __name__=id)
#    ob.title = title
#    ob.parents = []
#    username = getSecurityManager().getUser().getUserName()
#    ob.manage_addLocalRoles(username, ['Owner'])
#    #ob.setSubOwner('both') #?
#    return ob

# other CMFWiki stuff
#    initPageMetadata(ob)
#    for name, perm in ob._perms.items():
#        pseudoperm = default_perms[name]
#        local_roles_map = ob._local_roles_map
#        roles_map = ob._roles_map
#        roles = (local_roles_map[name],) + roles_map[pseudoperm]
#        ob.manage_permission(perm, roles=roles)

def _addDTMLMethod(self, id, title='', file=''):
    id=str(id)
    title=str(title)
    ob = DTMLMethod(source_string=file, __name__=id)
    ob.title = title
    username = getSecurityManager().getUser().getUserName()
    ob.manage_addLocalRoles(username, ['Owner'])
    #ob.setSubOwner('both') #?
    self._setObject(id, ob)

def listWikis(self):
    """
    list all wiki templates available in the filesystem or zodb

    >>> ZWiki.listWikis()
    ['basic-0.9.5', 'zwikidotorg', 'zwikidotorg-0.9.6']
    
    """
    list = self.listFsWikis()
    for w in self.listZodbWikis():
        if not w in list: list.append(w)
    list.sort()
    return list

def listZodbWikis(self):
    """
    list the wiki templates available in the ZODB

    >>> ZWiki.listZodbWikis()
    ['basic-0.9.5', 'zwikidotorg-0.9.6']
    """
    list = self.getPhysicalRoot().Control_Panel.Products.ZWiki.objectIds()
    list.remove('Help')
    return list
    
def listFsWikis(self):
    """
    list the wiki templates available in the filesystem

    >>> ZWiki.listFsWikis()
    ['zwikidotorg']
    
    """
    list = os.listdir(package_home(globals()) + os.sep + 'wikis')
    # temporary
    if 'CVS' in list: list.remove('DEFAULTS')
    if 'DEFAULTS' in list: list.remove('DEFAULTS')
    return list
    
